package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.helpers.enums.AuthentificationResult;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.SdkResponseModels.ProcessUploadCompletion;

public class IdenfyController {


    private IdenfySettings settings;
    private String test;
    public static ExitCode exitCode;
    public static IdenfyErrorResponse idenfyError;
    public static ProcessUploadCompletion processUploadCompletion;
    public static AuthenticationResultResponse authenticationResultResponse;
    private static final int exitCodeTerminated = -1;
    public static boolean isNewWayOfIdentification = true;


    public void initialize(@NonNull IdenfySettings settings1, @Nullable AuthenticationListener listener) {
        this.settings = settings1;
        mListener = listener;
    }

    public void startAutentification(@NonNull Context context) {
        if (settings == null) {
            throw new IllegalStateException("call IdenfyContoller.getInstance().initialize(...) first");
        } else {
            settings.setNewWayOfIdentification(false);
            Intent intent = new Intent(context, CameraPreviewActivity.class);
            context.startActivity(intent);
        }

    }

    public static void handleActivityResult(int resultCode, Intent data, AuthenticationListenerNew authenticationListenerNew) {
        if (idenfyError != null)
            authenticationListenerNew.onError(idenfyError);
        if (processUploadCompletion != null)
            authenticationListenerNew.onProcessCompleted(processUploadCompletion);
        if (exitCode == null && idenfyError == null && authenticationResultResponse == null) {
            authenticationListenerNew.onUserExit(new ExitCode(exitCodeTerminated));
        } else if (idenfyError == null && authenticationResultResponse == null) {
            authenticationListenerNew.onUserExit(exitCode);
        }
        if (authenticationResultResponse != null) {
            authenticationListenerNew.onAuthenticationResult(authenticationResultResponse);
        }
    }

    public interface AuthenticationListener {
        void onAutentification(AuthentificationResult result);
    }

    public interface AuthenticationListenerNew {
        default void onProcessCompleted(ProcessUploadCompletion result) {
            return;
        }

        default void onUserExit(ExitCode result) {

        }

        default void onError(IdenfyErrorResponse result) {

        }

        ;

        void onAuthenticationResult(AuthenticationResultResponse authenticationResultResponse);

    }

    private IdenfyController() {

    }

    public AuthenticationListener mListener;

    public AuthenticationListener getmListener() {
        if (mListener != null)
            return mListener;
        else {
            mListener = new AuthenticationListener() {
                @Override
                public void onAutentification(AuthentificationResult result) {

                }
            };
        }
        return mListener;
    }

    public void setmListener(AuthenticationListener mListener) {
        this.mListener = mListener;
    }

    public static IdenfyController getInstance() {

        if (instance == null) {
            instance = new IdenfyController();
        }

        return instance;
    }

    public void startAuthentication(Activity context, int requestCode, IdenfySettings idenfySettings) {
        this.settings = idenfySettings;
        if (settings == null) {
            throw new IllegalStateException("call IdenfyContoller.getInstance().initialize(...) first");
        } else {
            isNewWayOfIdentification = true;
            Intent intent = new Intent(context, CameraPreviewActivity.class);
            this.settings.setHandleResultsChecking(false);
            settings.setNewWayOfIdentification(true);
            context.startActivityForResult(intent, requestCode);
        }
    }

    public void setSettings(@NonNull IdenfySettings settings) {
        this.settings = settings;
    }

    public IdenfySettings getSettings() {
        return this.settings;
    }

    private static IdenfyController instance;

}
