package com.idenfy.idenfySdk.SdkResponseModels;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class IdenfyErrorResponse implements Parcelable {
    protected IdenfyErrorResponse(Parcel in) {
        message = in.readString();
        identifier = in.readString();
    }

    public static final Creator<IdenfyErrorResponse> CREATOR = new Creator<IdenfyErrorResponse>() {
        @Override
        public IdenfyErrorResponse createFromParcel(Parcel in) {
            return new IdenfyErrorResponse(in);
        }

        @Override
        public IdenfyErrorResponse[] newArray(int size) {
            return new IdenfyErrorResponse[size];
        }
    };

    @Override
    public String toString() {
        return "IdenfyErrorResponse{" +
                "message='" + message + '\'' +
                ", identifier='" + identifier + '\'' +
                '}';
    }

    @SerializedName("message")
    @Expose
    private String message;
    @SerializedName("identifier")
    @Expose
    private String identifier;

    public IdenfyErrorResponse(String identifier, String message) {
        this.identifier = identifier;
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(message);
        dest.writeString(identifier);
    }
}