package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

public class IdenfySettings implements Parcelable {

    public boolean optionalResultsChecking = false;
    private String selectedCountry;
    private Typeface font;
    private @Nullable
    String token;
    private @Nullable
    Boolean handleResultsChecking = false;

    private @Nullable
    String selectedSdkCustomLocale = null;

    private @Nullable
    boolean isNewWayOfIdentification = true;
    private String customFontPath;

    protected IdenfySettings(Parcel in) {
        optionalResultsChecking = in.readByte() != 0;
        selectedCountry = in.readString();
        token = in.readString();
        byte tmpHandleResultsChecking = in.readByte();
        handleResultsChecking = tmpHandleResultsChecking == 0 ? null : tmpHandleResultsChecking == 1;
        selectedSdkCustomLocale = in.readString();
        isNewWayOfIdentification = in.readByte() != 0;
        customFontPath = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte) (optionalResultsChecking ? 1 : 0));
        dest.writeString(selectedCountry);
        dest.writeString(token);
        dest.writeByte((byte) (handleResultsChecking == null ? 0 : handleResultsChecking ? 1 : 2));
        dest.writeString(selectedSdkCustomLocale);
        dest.writeByte((byte) (isNewWayOfIdentification ? 1 : 0));
        dest.writeString(customFontPath);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<IdenfySettings> CREATOR = new Creator<IdenfySettings>() {
        @Override
        public IdenfySettings createFromParcel(Parcel in) {
            return new IdenfySettings(in);
        }

        @Override
        public IdenfySettings[] newArray(int size) {
            return new IdenfySettings[size];
        }
    };

    public String getCustomFontPath()
    {
        return customFontPath;
    }


    @Nullable
    public boolean isNewWayOfIdentification() {
        return isNewWayOfIdentification;
    }

    public void setNewWayOfIdentification(@Nullable boolean newWayOfIdentification) {
        isNewWayOfIdentification = newWayOfIdentification;
    }

    public Typeface getIdenfyFont(FontEnum fontEnum) {
        if (this.font != null) {
            return this.font;
        }

        return fontEnum.getTypeface();
    }

    public void setFont(String font) {

        this.customFontPath = font;
    }


    @Nullable
    public Boolean getHandleResultsChecking() {
        return handleResultsChecking;
    }

    public IdenfySettings(@NonNull String token, @NonNull Context context) {
        this.token = token;
    }
    @Nullable
    public String getToken() {
        return token;
    }


    public void setCustomLocale(String locale)
    {
        selectedSdkCustomLocale = locale;
    }
    public String getCustomLocale()
    {

        return selectedSdkCustomLocale;
    }
    public String getSelectedCountry() {
        return selectedCountry;
    }

    public void setSelectedCountry(@NonNull String selectedCountry) {
        this.selectedCountry = selectedCountry;
    }

    void setHandleResultsChecking(boolean optionalHandeling) {
        this.handleResultsChecking = optionalHandeling;
    }


    @Override
    public String toString() {
        return "IdenfySettings{" +
                ", selectedCountry='" + selectedCountry + '\'' +
                ", font=" + font +
                ", token='" + token + '\'' +
                ", handleResultsChecking=" + handleResultsChecking +
                '}';
    }

    public void setCustomTypeface(Typeface idenfyFont) {

            font = idenfyFont;
    }
}
