package com.idenfy.idenfySdk.ViewModelsCoreLogic;

import android.app.Application;


import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MediatorLiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.Handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.util.SparseArray;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.Networking.Models.SetDeviceTypeForAPI;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.Networking.RetrofitFactory;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.CountryEnum;
import com.idenfy.idenfySdk.helpers.DocumentWrapper;
import com.idenfy.idenfySdk.helpers.SingleLiveEvent;
import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest;
import com.idenfy.idenfySdk.Networking.Models.CountryCode;
import com.idenfy.idenfySdk.Networking.Models.CountrySetRequest;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.Networking.RetrofitFactoryUploadingFiles;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfySdk.R;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.SdkResponseModels.ProcessUploadCompletion;
import com.idenfy.idenfySdk.SdkResponseModels.AuthenticationResultClass;
import com.idenfy.idenfySdk.Networking.Models.StreamPost;


import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class CameraViewModel extends AndroidViewModel {
    public Context applicationContext;
    public MutableLiveData<DocumentType> currentDocument = new MutableLiveData<>();
    private HashMap<DocumentType, Boolean> uploadsFinishedHashMap;
    private HashMap<String, Boolean> loadingFinishedHasMap;
    public MutableLiveData<List<DocumentType>> retakeDocumentsList = new MutableLiveData<>();
    private MutableLiveData<Resource<List<Country>>> countriesListFinalMutableLiveData = new MutableLiveData<>();
    private MutableLiveData<Resource<ResponseBody>> countrySetForDocumentMutableLiveData;
    private int cameraDelay = 600;
    public long CHECKING_RESULTS_START_DELAY = 1000;
    public long CHECKING_RESULTS_PINNING_DELAY = 1000;
    private static final String DEVICE_TYPE = "MOBILE_SDK";

    //UPLOADS MANAGEMENT
    private MutableLiveData<Resource<ResponseBody>> idCardFrontUploaded = new MutableLiveData<>();
    private MutableLiveData<Resource<ResponseBody>> idCardBackUploaded = new MutableLiveData<>();
    private MutableLiveData<Resource<ResponseBody>> passportUploaded = new MutableLiveData<>();
    private MutableLiveData<Resource<ResponseBody>> facePhotoUpload = new MutableLiveData<>();
    private MediatorLiveData<HashMap<DocumentType, Boolean>> uploadsFinished = new MediatorLiveData<>();
    //UI/UX VISIBILITY AND AVAILABILITY
    private MutableLiveData<Boolean> cameraViewVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> nextButtonVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> facePhotoVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> actionButtonVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> recreateButtonVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> showImageLayoutVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> cropShapeImageViewVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> nextButtonAvailability = new MutableLiveData<>();
    MutableLiveData<Boolean> recreateButtonAvailability = new MutableLiveData<>();
    MutableLiveData<Boolean> takePictureButtonAvailability = new MutableLiveData<>();
    MutableLiveData<String> imageViewResultTitleMutableLiveData = new MutableLiveData<>();
    MutableLiveData<String> imageViewResultTitleColorMutableLiveData = new MutableLiveData<>();
    MutableLiveData<String> documentTutorialTitleColorMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Integer> resultPhotoWidthMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Drawable> backButtonDrawableMutableLiveData = new MutableLiveData<>();

    //DOCUMENT TYPES, INFO
    MutableLiveData<DocumentWrapper> documentInfo = new MutableLiveData<>();
    MutableLiveData<Boolean> isBackFotoapparatCamera = new MutableLiveData<>();
    MutableLiveData<DocumentType> documentTypeMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Boolean> imageViewResult = new MutableLiveData<>();
    MutableLiveData<Boolean> imageViewResultFullSize = new MutableLiveData<>();
    MutableLiveData<AuthenticationResultClass> authenticationResultClassMutableLiveData = new MutableLiveData<>();
    public MutableLiveData<Boolean> authenticationFragmentOpenMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Boolean> documentTutorialTitleVisibility = new MutableLiveData<>();
    MutableLiveData<Resource<String>> checkAuthTokenMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Resource<String>> checkSixDigitTokenMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Resource<String>> firstCountryFromIPMutableLiveData = new MutableLiveData<>();
    public SingleLiveEvent<Resource<ResponseBody>> setDocumentTypeResponseMutableLiveData = new SingleLiveEvent<>();
    public MediatorLiveData<Resource<HashMap<String, Boolean>>> mainLoadingMediatorLiveDara = new MediatorLiveData<>();

    //ADDING REMOVING VIEWS, SAFELY
    private MutableLiveData<Boolean> addCameraFragment = new MutableLiveData<>();
    private MutableLiveData<Boolean> dismissCountryDialog = new MutableLiveData<>();
    private MutableLiveData<Boolean> addSixDigitsBarcodeFragmentMutableLiveData = new MutableLiveData<>();
    private MutableLiveData<Boolean> addInitialAgreementFragmentMutableLiveData = new MutableLiveData<>();
    // private MutableLiveData<Boolean> canSetCameraView = new MutableLiveData<>();

    //CONSTANTS
    public static final String loadingLiveDataCountriesKey = "CountriesList";
    public static final String loadingLiveDataAuthTokenKey = "AuthToken";
    public static final String loadingLiveDataFirstCountryKey = "FirstCountry";

    private MutableLiveData<List<DocumentType>> photosNeededToUpload = new MutableLiveData<>();

    public LiveData<Resource<ResponseBody>> getCountrySetForDocumentMutableLiveData() {
        if (countrySetForDocumentMutableLiveData == null) {
            countrySetForDocumentMutableLiveData = new MutableLiveData<>();
        }
        return this.countrySetForDocumentMutableLiveData;
    }


    public void setUploadsFinishedFalse(DocumentType documentType) {
        uploadsFinishedHashMap.put(documentType, false);
    }


    public CameraViewModel(@NonNull Application application) {
        super(application);
        setupSourcesForMainMediator();
        retakeDocumentsList.postValue(new ArrayList<>());
        uploadsFinishedHashMap = new HashMap<>();
        applicationContext = application.getApplicationContext();
        mainActivityViewVisibility.postValue(true);
        uploadsFinished.addSource(idCardBackUploaded, new Observer<Resource<ResponseBody>>() {
            @Override
            public void onChanged(@Nullable Resource<ResponseBody> response) {
                if (response != null) {
                    uploadsFinishedHashMap.put(DocumentType.ID_CARD_BACK, true);
                    uploadsFinished.postValue(uploadsFinishedHashMap);
                }
            }
        });
        uploadsFinished.addSource(passportUploaded, new Observer<Resource<ResponseBody>>() {
            @Override
            public void onChanged(@Nullable Resource<ResponseBody> response) {
                if (response != null) {
                    uploadsFinishedHashMap.put(DocumentType.PASSPORT, true);
                    uploadsFinished.postValue(uploadsFinishedHashMap);
                }
            }
        });
        uploadsFinished.addSource(idCardFrontUploaded, new Observer<Resource<ResponseBody>>() {
            @Override
            public void onChanged(@Nullable Resource<ResponseBody> response) {
                if (response != null) {
                    uploadsFinishedHashMap.put(DocumentType.ID_CARD_FRONT, true);
                    uploadsFinished.postValue(uploadsFinishedHashMap);
                }
            }
        });

        uploadsFinished.addSource(facePhotoUpload, new Observer<Resource<ResponseBody>>() {
            @Override
            public void onChanged(@Nullable Resource<ResponseBody> response) {
                if (response != null) {
                    uploadsFinishedHashMap.put(DocumentType.FACE_PHOTO, true);
                    uploadsFinished.postValue(uploadsFinishedHashMap);
                }
            }
        });
    }

    private void setupSourcesForMainMediator() {
        loadingFinishedHasMap = new HashMap<>();
        mainLoadingMediatorLiveDara.addSource(countriesListFinalMutableLiveData, new Observer<Resource<List<Country>>>() {
            @Override
            public void onChanged(@Nullable Resource<List<Country>> response) {
                if (response != null) {
                    if (response.status == Status.SUCCESS) {
                        loadingFinishedHasMap.put(loadingLiveDataCountriesKey, true);
                    }
                    mainLoadingMediatorLiveDara.postValue(Resource.success(loadingFinishedHasMap));
                }
            }
        });
        mainLoadingMediatorLiveDara.addSource(checkAuthTokenMutableLiveData, new Observer<Resource<String>>() {
            @Override
            public void onChanged(@Nullable Resource<String> response) {
                if (response != null) {
                    if (response.status == Status.SUCCESS) {
                        loadingFinishedHasMap.put(loadingLiveDataAuthTokenKey, true);
                    }
                    mainLoadingMediatorLiveDara.postValue(Resource.success(loadingFinishedHasMap));


                }
            }
        });
        mainLoadingMediatorLiveDara.addSource(firstCountryFromIPMutableLiveData, response ->
        {
            if (response != null) {
                if (response.status == Status.SUCCESS) {
                    loadingFinishedHasMap.put(loadingLiveDataFirstCountryKey, true);
                }
                mainLoadingMediatorLiveDara.postValue(Resource.success(loadingFinishedHasMap));
            }
        });
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        applicationContext = null;
    }


    public SingleLiveEvent<Resource<ResponseBody>> getSetDocumentTypeResponseMutableLiveData() {
        return this.setDocumentTypeResponseMutableLiveData;


    }

    MutableLiveData<Resource<List<Country>>> countriesListMutableLiveData = new MutableLiveData<>();
    protected SparseArray<ArrayList<Country>> mCountriesMap = new SparseArray<ArrayList<Country>>();


    //SDK Responses
    public MutableLiveData<Resource<ProcessUploadCompletion>> processUploadCompletion =
            new MutableLiveData<>();

    MutableLiveData<IdenfyError> idenfyError =
            new MutableLiveData<>();
    MutableLiveData<Resource<ExitCode>> exitCode =
            new MutableLiveData<>();

    public LiveData<Resource<ProcessUploadCompletion>> getProcessUploadCompletion() {
        return this.processUploadCompletion;
    }


    public LiveData<IdenfyError> getIdenfyError() {
        return this.idenfyError;
    }

    public LiveData<Resource<ExitCode>> getExitCode() {
        return this.exitCode;
    }


    private String getBase64(DocumentType type) {

        Bitmap bm = BitmapFactory.decodeFile(new File(getFilesDir(), type.getFilename()).getPath());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 90, baos); //bm is the bitmap object
        byte[] byteArrayImage = baos.toByteArray();

        String encodedImage = Base64.encodeToString(byteArrayImage, Base64.DEFAULT);
        File file = new File(Environment.getExternalStorageDirectory(), type.getFilename());
        file.delete();

        return encodedImage;
    }


    public void setPhotosNeededToUpload(DocumentType documentType) {
        if (documentType == DocumentType.ID_CARD_FRONT) {
            List<DocumentType> documentTypesList = new ArrayList<>();
            documentTypesList.add(DocumentType.ID_CARD_BACK);
            documentTypesList.add(DocumentType.ID_CARD_FRONT);
            documentTypesList.add(DocumentType.FACE_PHOTO);
            photosNeededToUpload.setValue(documentTypesList);
        } else if (documentType == DocumentType.PASSPORT) {
            List<DocumentType> documentTypesList = new ArrayList<>();
            documentTypesList.add(DocumentType.PASSPORT);
            documentTypesList.add(DocumentType.FACE_PHOTO);
            photosNeededToUpload.setValue(documentTypesList);
        }
    }

    public void removeDocumentNeededToUpload(DocumentType documentType) {
        if (photosNeededToUpload.getValue() != null) {
            List<DocumentType> documentTypes = photosNeededToUpload.getValue();
            documentTypes.remove(documentType);
            photosNeededToUpload.postValue(documentTypes);
        }
    }

    public MutableLiveData<Boolean> optionalResultsCheckingMutableLiveData = new MutableLiveData<>();

    public void startProcessing() {
        processUploadCompletion.postValue(Resource.loading(null));
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {


                AuthTokenRequest authTokenRequest = new AuthTokenRequest();
                authTokenRequest.setAuthToken(IdenfyController
                        .getInstance().getSettings().getToken());
                Call<ResponseBody> call = RetrofitFactoryUploadingFiles.create().startProcess(authTokenRequest);
                call.enqueue(new Callback<ResponseBody>() {
                    @Override
                    public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                        if (response.isSuccessful()) {
                            if (IdenfyController.getInstance().getSettings().optionalResultsChecking) {
                                optionalResultsCheckingMutableLiveData.postValue(true);
                            } else
                                processUploadCompletion.postValue(Resource.success(new ProcessUploadCompletion(true)));
                        } else {
                            JsonParser parser = new JsonParser();
                            JsonElement mJson = null;
                            try {
                                ResponseBody errorBody = response.errorBody();
                                if (errorBody != null) {
                                    mJson = parser.parse(errorBody.string());
                                    try {
                                        Gson gson = new GsonBuilder().setLenient().create();
                                        IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                        idenfyError.postValue(new IdenfyError(errorResponse, true));
                                    } catch (Exception ex) {
                                        idenfyError.postValue(new IdenfyError(new
                                                IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true));
                                        ex.printStackTrace();
                                    }
                                }
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new
                                        IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void onFailure(Call<ResponseBody> call, Throwable t) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));

                    }
                });
            }

        }, 0);

    }


    public LiveData<Resource<String>> getCountryFromIPLiveDataAndDecideToShowFragment() {
        if (firstCountryFromIPMutableLiveData == null) {
            firstCountryFromIPMutableLiveData = new MutableLiveData<>();
        }
        return this.firstCountryFromIPMutableLiveData;
    }

    public LiveData<Resource<String>> getSixDigitTokenMutableLiveData() {
        return this.checkSixDigitTokenMutableLiveData;
    }

    public void setCheckSixDigitTokenMutableLiveDataLoading() {
        this.checkSixDigitTokenMutableLiveData.postValue(Resource.loading(null));
    }

    public void setAuthTokenMutableLiveDataLoading() {
        this.checkAuthTokenMutableLiveData.postValue(Resource.loading(null));
    }

    public LiveData<Resource<String>> getCheckAuthTokenLiveData() {
        return this.checkAuthTokenMutableLiveData;
    }


    public LiveData<Boolean> getDismissCountryDialogLiveData() {
        return dismissCountryDialog;
    }

    public void setDismissCountryDialogMutableLiveData(boolean b) {
        dismissCountryDialog.postValue(b);
    }


    boolean shouldStopLoop;
    Handler mHandler;
    public boolean secondTime = false;

    public void startCheckingForAuthenticationesults() {
        startCheckingForAuthenticationResultsNew();
    }

    boolean result = false;
    public MutableLiveData<Resource<AuthenticationResultResponse>> authneticationResultResponse = new MutableLiveData<>();

    public void setDeviceTypeForAPI() {

        SetDeviceTypeForAPI setDeviceTypeForAPI = new SetDeviceTypeForAPI(IdenfyController
                .getInstance().getSettings().getToken(),
                DEVICE_TYPE);
        Call<SetDeviceTypeForAPI> call =
                RetrofitFactory.create().setDeviceTypeForAPI(setDeviceTypeForAPI);

        call.enqueue(new Callback<SetDeviceTypeForAPI>() {
            @Override
            public void onResponse(@NonNull Call<SetDeviceTypeForAPI> call, @NonNull Response<SetDeviceTypeForAPI> response) {
                if (response.isSuccessful()) {

                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                mJson = parser.parse(errorBody.string());
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(
                                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(
                                new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                        getApplication().getApplicationContext().getResources()
                                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                    }
                }
            }

            @Override
            public void onFailure(@NonNull Call<SetDeviceTypeForAPI> call, @NonNull Throwable t) {
                idenfyError.postValue(new IdenfyError(
                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });
    }

    public void startCheckingForAuthenticationResultsNew() {

        AuthTokenRequest streamPost = new AuthTokenRequest();
        streamPost.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        Call<AuthenticationResultResponse> authenticationResultResponseCall =
                RetrofitFactory.create().checkAuthenticationStatus(streamPost);
        authenticationResultResponseCall.enqueue(new Callback<AuthenticationResultResponse>() {

            @Override
            public void onResponse(@NonNull Call<AuthenticationResultResponse> call, @NonNull Response<AuthenticationResultResponse> response) {
                AuthenticationResultResponse responseBodyUsable = response.body();
                if (response.isSuccessful()) {
                    if (responseBodyUsable != null) {
                        AuthenticationResultResponse authenticationResultResponse = response.body();
                        authneticationResultResponse.postValue(Resource.success(response.body()));
                        if (authenticationResultResponse != null && !authenticationResultResponse.getProcessingStatus().equalsIgnoreCase("FINISHED")) {
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    startCheckingForAuthenticationResultsNew();
                                }
                            }, CHECKING_RESULTS_START_DELAY);
                        }

                    }

                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                mJson = parser.parse(errorBody.string());
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                                authneticationResultResponse.postValue(Resource.success(response.body()));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(
                                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(
                                new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                        getApplication().getApplicationContext().getResources()
                                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }


            @Override
            public void onFailure(@NonNull Call<AuthenticationResultResponse> call, @NonNull Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getApplicationContext().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));

            }
        });
    }

    public void setCurrentDocument(DocumentType document) {
        this.currentDocument.postValue(document);
    }

    public void fetchCountriesList() {

        countriesListMutableLiveData.postValue(Resource.loading(null));
        List<CountryEnum> country_enums =
                new ArrayList<CountryEnum>(EnumSet.allOf(CountryEnum.class));
        List<Country> countryList = new ArrayList<>();
        for (int i = 0; i < country_enums.size(); i++) {
            countryList.add(new Country(country_enums.get(i), i, applicationContext));
        }
        countriesListMutableLiveData.postValue(Resource.success(countryList));
    }

    public void setCountriesList(Resource<List<Country>> countriesList) {
        this.countriesListFinalMutableLiveData.postValue(countriesList);
    }

    public void setCountryForDocument(Country value) {
        if (value != null) {
            setCountryForDocumentRequest(value);
        }
    }

    public void startSession() {
        AuthTokenRequest authTokenRequest = new AuthTokenRequest();
        authTokenRequest.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        Call<ResponseBody> call = RetrofitFactoryUploadingFiles.create().startSession(authTokenRequest);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    //TODO new mutableLiveData
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            mJson = parser.parse(errorBody.string());
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));

            }
        });
    }

    private void setCountryForDocumentRequest(Country value) {

        CountrySetRequest authTokenRequest = new CountrySetRequest();
        authTokenRequest.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        authTokenRequest.setCountry(value.getCountryISO());

        Call<ResponseBody> call = RetrofitFactoryUploadingFiles.create().setIssuingCountry(authTokenRequest);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    IdenfyController.getInstance().getSettings().setSelectedCountry(
                            value.getCountryISO());
                    countrySetForDocumentMutableLiveData.postValue(Resource.success(response.body()));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                mJson = parser.parse(errorBody.string());
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });

    }


    public void setDocumentType(DocumentType document) {
        setDocumentTypeResponseMutableLiveData.postValue(Resource.loading(null));
        Map<String, String> requestBody = new HashMap<>();
        requestBody.put("authToken", IdenfyController.getInstance().getSettings().getToken());
        requestBody.put("documentType", document.getDocumentSetName());
        Call<ResponseBody> responseBodyCall = RetrofitFactory.create().setDocumentType(requestBody);
        responseBodyCall.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    setDocumentTypeResponseMutableLiveData.postValue(Resource.success(response.body()));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            mJson = parser.parse(errorBody.string());
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                setDocumentTypeResponseMutableLiveData.postValue(Resource.error(new IdenfyError(errorResponse,
                                        true)));
                                idenfyError.postValue(new IdenfyError(errorResponse,
                                        true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                            }
                        } else {
                            idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                    .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                    getApplication().getApplicationContext().getResources()
                                            .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                    true));
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        setDocumentTypeResponseMutableLiveData.postValue(Resource.error(new IdenfyError(new
                                IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)), true)));
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                setDocumentTypeResponseMutableLiveData.postValue(Resource.error(new IdenfyError(new
                        IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getApplicationContext().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)), true)));
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getApplicationContext().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });
    }

    public void checkAuthTokenRequest(String authToken, Boolean sixDigits, String sixDigitsCode) {

        AuthTokenRequest authTokenRequest = new AuthTokenRequest();
        authTokenRequest.setAuthToken(authToken);
        Call<ResponseBody> responseBodyCall = RetrofitFactory.create().checkAuthToken(authTokenRequest);
        responseBodyCall.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseBody) {

                if (responseBody.isSuccessful()) {
                    try {
                        ResponseBody responseBodyUsable = responseBody.body();
                        if (responseBodyUsable != null) {

                            String response = responseBodyUsable.string();
                            if (response.equalsIgnoreCase("1")) {
                                checkAuthTokenMutableLiveData.postValue(Resource.success(response));
                            } else {

                                {
                                    idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                            .getString(R.string.TOKEN_NOT_VALID_IDENTIFIER),
                                            getApplication().getApplicationContext().getResources()
                                                    .getString(R.string.TOKEN_NOT_VALID_MESSAGE)),
                                            false));
                                    checkAuthTokenMutableLiveData.postValue(Resource.error(response));
                                }
                            }
                        } else {
                            idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                    .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                    getApplication().getApplicationContext().getResources()
                                            .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                    false));
                            checkAuthTokenMutableLiveData.postValue(Resource.error("Some server isuess..."));
                        }
                    } catch (Exception e) {

                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                false));

                        e.printStackTrace();
                        checkAuthTokenMutableLiveData.postValue(Resource.error("Some server isuess..."));
                    }


                } else {
                    idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                            .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                            getApplication().getApplicationContext().getResources()
                                    .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                            true));

                    checkAuthTokenMutableLiveData.postValue(Resource.error("Some server isuess..."));
                }

            }


            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getApplicationContext().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        false));
                checkAuthTokenMutableLiveData.postValue(Resource.error(t));
            }
        });
    }


    public void setImageViewResultTitleColorMutableLiveData(String colorMutableLiveData) {
        this.imageViewResultTitleColorMutableLiveData.postValue(colorMutableLiveData);
    }

    public void setDocumentTutorialTitleColorMutableLiveData(String colorMutableLiveData) {
        this.documentTutorialTitleColorMutableLiveData.postValue(colorMutableLiveData);
    }

    public LiveData<String> getImageViewResultTitleColorMutableLiveData() {
        return this.imageViewResultTitleColorMutableLiveData;
    }

    public LiveData<String> getDocumentTutorialTitleColorMutableLiveData() {
        return this.documentTutorialTitleColorMutableLiveData;
    }

    public void setBackButtonDrawableMutableLiveData(Drawable drawableMutableLiveData) {
        this.backButtonDrawableMutableLiveData.postValue(drawableMutableLiveData);
    }

    public LiveData<Drawable> getBackButtonDrawableMutableLiveData() {
        return this.backButtonDrawableMutableLiveData;
    }

    public void setTakePictureButtonAvailability(boolean available) {
        takePictureButtonAvailability.postValue(available);
    }

    public void setNextButtonAvailability(boolean available) {
        this.nextButtonAvailability.postValue(available);
    }

    public void setRecreateButtonAvailability(boolean available) {
        this.recreateButtonAvailability.postValue(available);
        this.recreateButtonAvailability.postValue(available);
    }

    public LiveData<Boolean> getTakePictureButtonAvailability() {
        return this.takePictureButtonAvailability;
    }

    public LiveData<Integer> getResultPhotoWidthMutableLiveData() {
        return resultPhotoWidthMutableLiveData;
    }

    public void setResultPhotoWidthMutableLiveData(Integer value) {
        this.resultPhotoWidthMutableLiveData.postValue(value);
    }

    public LiveData<Boolean> getNextButtonAvailability() {
        return this.nextButtonAvailability;
    }

    public LiveData<Boolean> getRecreateButtonAvailability() {
        return this.recreateButtonAvailability;
    }

    public ArrayList<DocumentType> documents;

    public static final String FRONT_FILENAME = "front.jpeg";
    public static final String BACK_FILENAME = "back.jpeg";
    public static final String FACE_FILENAME = "face.jpeg";


    public void setAddCameraFragment(boolean value) {
        this.addCameraFragment.postValue(value);
    }

    public LiveData<Boolean> getAddCameraFragment() {
        return this.addCameraFragment;
    }

    public boolean isRecyclerViewEnabled = false;
    public Boolean shouldDeleteCustomViews = false;

    public LiveData<Boolean> addInitialAgreementFragmentLiveData() {
        if (this.addInitialAgreementFragmentMutableLiveData == null) {
            addInitialAgreementFragmentMutableLiveData = new MutableLiveData<>();
            addInitialAgreementFragmentMutableLiveData.setValue(false);
        }
        return this.addInitialAgreementFragmentMutableLiveData;
    }

    public Boolean checkBoxChecked = false;
    public Boolean check2BoxChecked = false;
    public Boolean countrySelected = false;
    MutableLiveData<Boolean> initialAgreementButtonAvailability = new MutableLiveData<>();

    public MutableLiveData<Boolean> getInitialAgreementButtonAvailability() {
        return initialAgreementButtonAvailability;
    }

    public void setInitialAgreementButtonAvailability(Boolean initialAgreementButtonAvailability) {
        this.initialAgreementButtonAvailability.postValue(initialAgreementButtonAvailability);
    }

    public void setAddInitialAgreementFragmentMutableLiveData(Boolean addInitialAgreementFragmentMutableLiveData) {
        this.addInitialAgreementFragmentMutableLiveData.postValue(addInitialAgreementFragmentMutableLiveData);
    }


    public void setAddSixDigitsFragmentMutableLiveData(Boolean addSixDigitsFragmentMutableLiveData) {
        addSixDigitsBarcodeFragmentMutableLiveData.postValue(addSixDigitsFragmentMutableLiveData);
    }

    public LiveData<Boolean> getDocumentTutorialTitleVisibility() {
        return documentTutorialTitleVisibility;
    }

    public void setDocumentTutorialTitleVisibility(Boolean documentTutorialTitleVisibility) {
        this.documentTutorialTitleVisibility.postValue(documentTutorialTitleVisibility);
    }

    public LiveData<Boolean> getAuthenticationResultFragmentLiveData() {
        return authenticationFragmentOpenMutableLiveData;
    }

    public void setAuthenticationFragmentOpenMutableLiveData(Boolean authenticationFragmentOpenMutableLiveData) {
        this.authenticationFragmentOpenMutableLiveData.postValue(authenticationFragmentOpenMutableLiveData);
    }

    public LiveData<Boolean> getCameraViewVisibility() {
        return cameraViewVisibility;
    }

    public LiveData<Boolean> getImageViewResult() {
        return imageViewResult;
    }

    public void setImageViewResult(Boolean imageViewResult) {
        this.imageViewResult.postValue(imageViewResult);
    }

    public LiveData<Boolean> getImageViewResultFullSize() {
        return imageViewResultFullSize;
    }

    public void setImageViewResultFullSize(Boolean imageViewResultFullSize) {
        this.imageViewResultFullSize.postValue(imageViewResultFullSize);
    }

    public void setShowImageLayoutVisibility(Boolean showImageLayoutVisibility) {
        this.showImageLayoutVisibility.postValue(showImageLayoutVisibility);
    }

    public LiveData<Boolean> getShowImageLayoutVisibility() {
        return showImageLayoutVisibility;
    }

    public void setCameraViewVisibility(Boolean cameraViewVisibility) {
        this.cameraViewVisibility.postValue(cameraViewVisibility);
    }

    public void setAuthenticationResultClassMutableLiveData(AuthenticationResultClass authenticationResultClassMutableLiveData) {
        this.authenticationResultClassMutableLiveData.postValue(authenticationResultClassMutableLiveData);
    }


    public LiveData<Boolean> getNextButtonVisibility() {
        return nextButtonVisibility;
    }

    public void setNextButtonVisibility(Boolean nextButtonVisibility) {
        this.nextButtonVisibility.setValue(nextButtonVisibility);
    }

    public LiveData<Boolean> getIsBackFotoapparatCamera() {
        return isBackFotoapparatCamera;
    }

    public void setIsBackFotoapparatCamera(Boolean isBackFotoapparatCamera) {

        if (isBackFotoapparatCamera) {
            if (this.isBackFotoapparatCamera.getValue() != null) {
                if (!this.isBackFotoapparatCamera.getValue()) {
                    this.isBackFotoapparatCamera.setValue(true);
                }
            }
        } else
            this.isBackFotoapparatCamera.setValue(isBackFotoapparatCamera);
    }

    public MutableLiveData<DocumentType> getDocumentTypeMutableLiveData() {
        return documentTypeMutableLiveData;
    }

    public void setDocumentTypeMutableLiveData(DocumentType documentTypeMutableLiveData) {
        this.documentTypeMutableLiveData.setValue(documentTypeMutableLiveData);
    }

    public MutableLiveData<Boolean> getFacePhotoVisibility() {
        return facePhotoVisibility;
    }

    public void setFacePhotoVisibility(Boolean facePhotoVisibility) {
        this.facePhotoVisibility.setValue(facePhotoVisibility);
    }

    public MutableLiveData<Boolean> getActionButtonVisibility() {
        return actionButtonVisibility;
    }

    public void setActionButtonVisibility(Boolean actionButtonVisibility) {
        this.actionButtonVisibility.setValue(actionButtonVisibility);
    }

    public MutableLiveData<Boolean> getRecreateButtonVisibility() {
        return recreateButtonVisibility;
    }

    public void setRecreateButtonVisibility(Boolean recreateButtonVisibility) {

        this.recreateButtonVisibility.setValue(recreateButtonVisibility);
    }

    public LiveData<DocumentWrapper> getDocumentInfo() {
        return documentInfo;
    }

    public MutableLiveData<Boolean> mainActivityViewVisibility = new MutableLiveData<>();

    public void setMainActivityViewVisibility(Boolean mainActivityViewVisibility) {
        if (this.mainActivityViewVisibility.getValue() == null) {
            this.mainActivityViewVisibility.postValue(mainActivityViewVisibility);
        }
        if (mainActivityViewVisibility != this.mainActivityViewVisibility.getValue()) {
            this.mainActivityViewVisibility.postValue(mainActivityViewVisibility);
        }
    }

    public void setDocumentInfo(DocumentWrapper documentWrapper) {
        documentInfo.setValue(documentWrapper);
        if (documentWrapper.getDocumentType() != null)
            setDocumentTypeMutableLiveData(documentWrapper.getDocumentType());

        setRecreateButtonVisibility(documentWrapper.isRecreateButtonVisibility());
        setFacePhotoVisibility(documentWrapper.isFacePhotoVisibility());
        setNextButtonVisibility(documentWrapper.isNextButtonVisibility());
        setCameraViewVisibility(documentWrapper.isCameraViewVisibility());
        setShowImageLayoutVisibility(documentWrapper.isShowImageLayoutVisibility());
        setCropShapeImageViewVisibility(documentWrapper.isCropShapeImageViewVisibility());
        setImageViewResult(documentWrapper.isImageViewResultVisibility());
        setImageViewResultFullSize(documentWrapper.isImageViewFullSizeResultVisibility());
        setActionButtonVisibility(documentWrapper.isActionButtonVisibility());
        setDocumentTutorialTitleVisibility(documentWrapper.isDocumentTitleTutorialVisibility());
        setTakePictureButtonAvailability(documentWrapper.isTakePictureButtonAvailability());

    }

    public LiveData<Boolean> cameraViewVisibility() {
        return cameraViewVisibility;
    }

    public LiveData<Boolean> getCropShapeImageView() {
        return cropShapeImageViewVisibility;
    }

    public void setCropShapeImageViewVisibility(Boolean cropShapeImageViewVisibility) {
        this.cropShapeImageViewVisibility.setValue(cropShapeImageViewVisibility);
    }

    public void clearUploadsFinished() {
        uploadsFinishedHashMap = new HashMap<>();
        uploadsFinished.postValue(uploadsFinishedHashMap);
    }

    public void clearRetakedSteps() {
        retakeDocumentsList.postValue(new ArrayList<>());

    }


    public LiveData<HashMap<DocumentType, Boolean>> getUploadsFinished() {
        return uploadsFinished;
    }

    private void saveFileToServer(DocumentType documentType) {
        switch (documentType) {
            case ID_CARD_FRONT:
                String authToken = IdenfyController
                        .getInstance().getSettings().getToken();
                String imageData = getBase64(documentType);
                String step = documentType.getDocumnetType();
                StreamPost streamPost = new StreamPost(authToken, imageData, step);

                Call<ResponseBody> responseBodySingle = RetrofitFactoryUploadingFiles.create().streamPhotoNew(streamPost);

                responseBodySingle.enqueue(new Callback<ResponseBody>() {
                    @Override
                    public void onResponse(@NonNull Call<ResponseBody> call,
                                           @NonNull Response<ResponseBody> response) {

                        if (response.isSuccessful()) {
                            idCardFrontUploaded.postValue(Resource.success(response.body()));
                        } else {
                            JsonParser parser = new JsonParser();
                            JsonElement mJson = null;
                            try {
                                ResponseBody errorBody = response.errorBody();
                                if (errorBody != null) {
                                    mJson = parser.parse(errorBody.string());
                                    try {
                                        Gson gson = new GsonBuilder().setLenient().create();
                                        IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                        idCardFrontUploaded.postValue(Resource.error(new IdenfyError(errorResponse,
                                                true)));
                                        idenfyError.postValue(new IdenfyError(errorResponse,
                                                true));
                                    } catch (Exception ex) {
                                        ex.printStackTrace();
                                        idCardFrontUploaded.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                                getApplication().getApplicationContext().getResources()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true)));
                                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true));
                                    }
                                }
                            } catch (Exception ex) {

                                idCardFrontUploaded.postValue(Resource.error(new IdenfyError(
                                        new IdenfyErrorResponse(
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER)),
                                        true)));
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();

                            }
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                        idCardFrontUploaded.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true)));
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));


                    }
                });
                break;
            case PASSPORT:
                authToken = IdenfyController
                        .getInstance().getSettings().getToken();
                imageData = getBase64(documentType);
                step = documentType.getDocumnetType();
                streamPost = new StreamPost(authToken, imageData, step);

                responseBodySingle = RetrofitFactoryUploadingFiles.create().streamPhotoNew(streamPost);

                responseBodySingle.enqueue(new Callback<ResponseBody>() {
                    @Override
                    public void onResponse(@NonNull Call<ResponseBody> call,
                                           @NonNull Response<ResponseBody> response) {

                        if (response.isSuccessful()) {
                            passportUploaded.postValue(Resource.success(response.body()));
                        } else {
                            JsonParser parser = new JsonParser();
                            JsonElement mJson = null;
                            try {
                                ResponseBody errorBody = response.errorBody();
                                if (errorBody != null) {
                                    mJson = parser.parse(errorBody.string());
                                    try {
                                        Gson gson = new GsonBuilder().setLenient().create();
                                        IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                        passportUploaded.postValue(Resource.error(new IdenfyError(errorResponse,
                                                false)));
                                        idenfyError.postValue(new IdenfyError(errorResponse,
                                                true));
                                    } catch (Exception ex) {
                                        passportUploaded.postValue(Resource.error(new IdenfyError(
                                                new IdenfyErrorResponse
                                                        (getApplication().getApplicationContext()
                                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                                getApplication().getApplicationContext()
                                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                false)));
                                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true));
                                        ex.printStackTrace();
                                    }
                                }
                            } catch (Exception ex) {
                                passportUploaded.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                        false)));
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();

                            }
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                        passportUploaded.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                false)));
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                    }
                });
                break;
            case ID_CARD_BACK:
                authToken = IdenfyController
                        .getInstance().getSettings().getToken();
                imageData = getBase64(documentType);
                step = documentType.getDocumnetType();
                streamPost = new StreamPost(authToken, imageData, step);

                responseBodySingle = RetrofitFactory.create().streamPhotoNew(streamPost);

                responseBodySingle.enqueue(new Callback<ResponseBody>() {
                    @Override
                    public void onResponse(@NonNull Call<ResponseBody> call,
                                           @NonNull Response<ResponseBody> response) {

                        if (response.isSuccessful()) {
                            idCardBackUploaded.postValue(Resource.success(response.body()));
                        } else {
                            JsonParser parser = new JsonParser();
                            JsonElement mJson = null;
                            try {
                                ResponseBody errorBody = response.errorBody();
                                if (errorBody != null) {
                                    mJson = parser.parse(errorBody.string());
                                    try {
                                        Gson gson = new GsonBuilder().setLenient().create();
                                        IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                        idCardBackUploaded.postValue(Resource.error(new IdenfyError(errorResponse,
                                                false)));
                                        idenfyError.postValue(new IdenfyError(errorResponse,
                                                true));
                                    } catch (Exception ex) {
                                        idCardBackUploaded.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                false)));
                                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true));
                                    }
                                }
                            } catch (Exception ex) {

                                idCardBackUploaded.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        false)));
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();

                            }
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                        idCardBackUploaded.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                false)));
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                    }
                });
                break;
            case FACE_PHOTO:
                authToken = IdenfyController
                        .getInstance().getSettings().getToken();
                imageData = getBase64(documentType);
                step = documentType.getDocumnetType();
                streamPost = new StreamPost(authToken, imageData, step);
                responseBodySingle = RetrofitFactoryUploadingFiles.create().streamPhotoNew(streamPost);

                responseBodySingle.enqueue(new Callback<ResponseBody>() {
                    @Override
                    public void onResponse(@NonNull Call<ResponseBody> call,
                                           @NonNull Response<ResponseBody> response) {

                        if (response.isSuccessful()) {
                            facePhotoUpload.postValue(Resource.success(response.body()));
                        } else {
                            JsonParser parser = new JsonParser();
                            JsonElement mJson = null;
                            try {
                                ResponseBody errorBody = response.errorBody();
                                if (errorBody != null) {
                                    mJson = parser.parse(errorBody.string());
                                    try {
                                        Gson gson = new GsonBuilder().setLenient().create();
                                        IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                        facePhotoUpload.postValue(Resource.error(new IdenfyError(errorResponse,
                                                false)));
                                        idenfyError.postValue(new IdenfyError(errorResponse,
                                                false));
                                    } catch (Exception ex) {
                                        facePhotoUpload.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true)));
                                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getApplicationContext()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true));
                                    }
                                }
                            } catch (Exception ex) {

                                facePhotoUpload.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        false)));
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();

                            }
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                        facePhotoUpload.postValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                false)));
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getApplicationContext()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                    }
                });
                break;
        }
    }

    public void checkIfCanSendToServer(List<DocumentType> retakeDocumentsList) {
        if (retakeDocumentsList.isEmpty()) {
            sendFilesToServer(getApplication().getApplicationContext());
        } else {
            changeDocument(retakeDocumentsList.get(0), false);
        }
    }

    public void setupNewDocument(Bitmap bitmap) {
        if (documentTypeMutableLiveData.getValue() != null) {
            decideWhichSaveBitmap(bitmap, documentTypeMutableLiveData.getValue());
            if (retakeDocumentsList.getValue() != null && retakeDocumentsList.getValue().isEmpty() && retakeDocumentsList
                    .getValue().isEmpty()) {
                switch (documentTypeMutableLiveData.getValue()) {
                    case ID_CARD_FRONT:
                        changeDocument(DocumentType.ID_CARD_BACK, false);
                        saveFileToServer(DocumentType.ID_CARD_FRONT);
                        break;
                    case PASSPORT:
                        changeDocument(DocumentType.FACE_PHOTO, false);
                        saveFileToServer(DocumentType.PASSPORT);
                        break;
                    case ID_CARD_BACK:
                        changeDocument(DocumentType.FACE_PHOTO, false);
                        saveFileToServer(DocumentType.ID_CARD_BACK);
                        break;
                    case FACE_PHOTO:
                        sendFilesToServer(applicationContext);
                        saveFileToServer(DocumentType.FACE_PHOTO);
                        break;
                }

            } else if (retakeDocumentsList.getValue() != null && !retakeDocumentsList.getValue().isEmpty()) {
                List<DocumentType> retakeDocumentsList = this.retakeDocumentsList.getValue();
                switch (this.retakeDocumentsList.getValue().get(0)) {
                    case ID_CARD_FRONT:
                        retakeDocumentsList = this.retakeDocumentsList.getValue();
                        retakeDocumentsList.remove(DocumentType.ID_CARD_FRONT);
                        this.retakeDocumentsList.setValue(retakeDocumentsList);
                        saveFileToServer(DocumentType.ID_CARD_FRONT);
                        checkIfCanSendToServer(retakeDocumentsList);
                        break;
                    case PASSPORT:
                        retakeDocumentsList = this.retakeDocumentsList.getValue();
                        retakeDocumentsList.remove(DocumentType.PASSPORT);
                        saveFileToServer(DocumentType.PASSPORT);
                        this.retakeDocumentsList.setValue(retakeDocumentsList);
                        checkIfCanSendToServer(retakeDocumentsList);
                        break;
                    case ID_CARD_BACK:
                        retakeDocumentsList = this.retakeDocumentsList.getValue();
                        retakeDocumentsList.remove(DocumentType.ID_CARD_BACK);
                        saveFileToServer(DocumentType.ID_CARD_BACK);
                        this.retakeDocumentsList.setValue(retakeDocumentsList);
                        checkIfCanSendToServer(retakeDocumentsList);
                        break;
                    case FACE_PHOTO:
                        retakeDocumentsList = this.retakeDocumentsList.getValue();
                        retakeDocumentsList.remove(DocumentType.FACE_PHOTO);
                        saveFileToServer(DocumentType.FACE_PHOTO);
                        this.retakeDocumentsList.setValue(retakeDocumentsList);
                        checkIfCanSendToServer(retakeDocumentsList);
                        break;
                }

            }
        }
    }

    public void fetchCountryByIp() {
        firstCountryFromIPMutableLiveData.postValue(Resource.loading(null));

        Call<CountryCode> responseBodySingle = RetrofitFactory.create().getCountryByIPAd();
        responseBodySingle.enqueue(new Callback<CountryCode>() {
            @Override
            public void onResponse(@NonNull Call<CountryCode> call, @NonNull Response<CountryCode> response) {
                if (response.isSuccessful()) {
                    CountryCode countryCode = response.body();
                    if (countryCode != null) {
                        firstCountryFromIPMutableLiveData.postValue(
                                Resource.success(countryCode.getCountry()));
                    }
                } else {
                    firstCountryFromIPMutableLiveData.postValue(
                            Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                    getApplication().getApplicationContext()
                                            .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                    getApplication().getApplicationContext()
                                            .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                    false)));
                    ;
                }
            }

            @Override
            public void onFailure(Call<CountryCode> call, Throwable t) {
                firstCountryFromIPMutableLiveData.postValue(
                        Resource.error(new IdenfyError(new IdenfyErrorResponse
                                (getApplication().getApplicationContext()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                false)));
            }
        });

    }

    public void decideWhichSaveBitmap(@NonNull Bitmap bitmap, @NonNull DocumentType type) {
        switch (type) {
            case ID_CARD_FRONT:
                documents = new ArrayList<>();
                documents.add(type);
                saveBitmap(bitmap, FRONT_FILENAME, false);
                break;
            case PASSPORT:
                documents = new ArrayList<>();
                documents.add(type);
                saveBitmap(bitmap, FRONT_FILENAME, true);
                break;
            case ID_CARD_BACK:
                documents.add(type);
                saveBitmap(bitmap, BACK_FILENAME, false);
                break;
            case FACE_PHOTO:
                documents.add(type);
                saveBitmap(bitmap, FACE_FILENAME, false);
                break;
        }
    }


    public File getFilesDir() {
        return applicationContext.getCacheDir();
    }

    public LiveData<Country> getSelectedCountryLiveData() {
        return this.selectedCountryMutableLiveData;
    }

    public LiveData<Resource<List<Country>>> getCountriesListMutableLiveData() {
        return this.countriesListMutableLiveData;
    }

    public void selectedCountry(Country item) {
        this.selectedCountryMutableLiveData.postValue(item);
    }

    private MutableLiveData<Country> selectedCountryMutableLiveData = new MutableLiveData<>();

    private void saveBitmap(@NonNull Bitmap bitmap, @NonNull String filename, boolean isPassport) {

        File sd = getFilesDir();
        File dest = new File(sd, filename);
        if (dest.exists()) {
            dest.delete();
        }

        try {
            if (!dest.createNewFile()) {
            } else {
            }
            FileOutputStream out = new FileOutputStream(dest);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, out);
            out.flush();
            out.close();

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public void sendFilesToServer(@NonNull final Context activity) {
        authneticationResultResponse.postValue(Resource.loading(null));
        setAuthenticationFragmentOpenMutableLiveData(true);
    }

    public void changeDocument(final DocumentType documentType, boolean isRecreated) {

        if (documentType == DocumentType.FACE_PHOTO) {
            if (!isRecreated) {
                setIsBackFotoapparatCamera(false);
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        setNextButtonVisibility(false);
                        setRecreateButtonVisibility(false);
                        setFacePhotoVisibility(true);
                        setDocumentTypeMutableLiveData(documentType);
                        setShowImageLayoutVisibility(false);
                        setActionButtonVisibility(true);
                        setDocumentTutorialTitleVisibility(true);
                    }
                }, cameraDelay);

            } else {
                setNextButtonVisibility(false);
                setRecreateButtonVisibility(false);
                setFacePhotoVisibility(true);
                setActionButtonVisibility(true);
                setDocumentTutorialTitleVisibility(true);
                setDocumentTypeMutableLiveData(documentType);
                setShowImageLayoutVisibility(false);
            }
        } else {
            if (!isRecreated) {
                setNextButtonVisibility(false);
                setRecreateButtonVisibility(false);
                setActionButtonVisibility(true);
                setDocumentTutorialTitleVisibility(true);
                setDocumentTypeMutableLiveData(documentType);
                setShowImageLayoutVisibility(false);
            } else {
                setNextButtonVisibility(false);
                setRecreateButtonVisibility(false);
                setActionButtonVisibility(true);
                setDocumentTutorialTitleVisibility(true);
                setShowImageLayoutVisibility(false);
            }
        }
    }

    public LiveData<String> getImageViewResultTitleMutableLiveData() {
        return this.imageViewResultTitleMutableLiveData;
    }

    public MutableLiveData<Boolean> authenticationSuccessForClosing = new MutableLiveData<>();

    public void setImageViewResultTitleMutableLiveData(DocumentType type) {
        switch (type) {
            case ID_CARD_FRONT:
                this.imageViewResultTitleMutableLiveData.postValue(getApplication().getApplicationContext().getResources().getString(R.string.show_pictured_document_bottom_passport_text));
                break;
            case PASSPORT:
                this.imageViewResultTitleMutableLiveData.postValue(getApplication().getApplicationContext().getResources().getString(R.string.show_pictured_document_bottom_passport_text));
                break;
            case ID_CARD_BACK:
                this.imageViewResultTitleMutableLiveData.postValue(getApplication().getApplicationContext().getResources().getString(R.string.show_pictured_document_bottom_card_back_text));
                break;
            case FACE_PHOTO:
                this.imageViewResultTitleMutableLiveData.postValue(getApplication().getApplicationContext().getResources().
                        getString(R.string.document_face_photo_result));
                break;
        }


    }


}
