package com.idenfy.idenfySdk.UI.MainActivity;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfySdk.R;

public class DocumentsRecyclerViewAdapter extends RecyclerView.Adapter<DocumentsRecyclerViewAdapter.ViewHolder> {

    private DocumentType[] documentTypes;
    private View.OnClickListener onClickListener;

    public interface onItemClickListener {
        void onClick(DocumentType type);
    }

    public DocumentsRecyclerViewAdapter(@NonNull DocumentType[] types, final onItemClickListener listener) {
        documentTypes = types;

        onClickListener = new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                DocumentType type = (DocumentType) view.getTag();
                type.setShowFront(true);
                listener.onClick(type);
            }
        };

    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // create a new view
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.documents_types_item, parent, false);


        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {

        DocumentType type = documentTypes[position];
        holder.textView.setText(type.getNameStringId());
        holder.imageView.setImageResource(type.getImageResId());
        holder.itemView.setOnClickListener(onClickListener);
        holder.itemView.setTag(type);
    }

    @Override
    public int getItemCount() {
        return documentTypes.length;
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        ImageView imageView;
        TextView textView;

        ViewHolder(View itemView) {

            super(itemView);

            imageView = itemView.findViewById(R.id.documentIcon);
            textView = itemView.findViewById(R.id.title);

        }
    }
}
