package com.idenfy.idenfySdk.UI.CountriesSelectionView;

import android.arch.lifecycle.ViewModelProviders;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.view.Display;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

import com.idenfySdk.R;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;

import java.util.ArrayList;
import java.util.List;

/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link CountriesSelectionFragment.OnFragmentInteractionListener} interface
 * to handle interaction events.
 * Use the {@link CountriesSelectionFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class CountriesSelectionFragment extends DialogFragment {
    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    private OnFragmentInteractionListener mListener;
    private CameraViewModel cameraViewModel;
    private CountriesRecyclerViewAdapter countryAdapter;
    private List<Country> countriesList;
    private String countryFromIdString;
    private RecyclerView recyclerView;

    public CountriesSelectionFragment() {
        // Required empty public constructor
    }


    public static CountriesSelectionFragment newInstance() {
        CountriesSelectionFragment fragment = new CountriesSelectionFragment();
        Bundle args = new Bundle();
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(DialogFragment.STYLE_NO_TITLE, R.style.DialogStyle);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
        cameraViewModel = ViewModelProviders.of(requireActivity()).get(CameraViewModel.class);

    }

    @Override
    public void onResume() {
        getDialog().getWindow().setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);
        Window window = getDialog().getWindow();
        getDialog().setCanceledOnTouchOutside(true);
        Point size = new Point();
        Display display = window.getWindowManager().getDefaultDisplay();
        display.getSize(size);
        window.setGravity(Gravity.CENTER);

        super.onResume();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        getDialog().setCanceledOnTouchOutside(true);
        setCancelable(true);
        super.onViewCreated(view, savedInstanceState);
        SearchView searchView = view.findViewById(R.id.countries_search_view);
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            @Override
            public boolean onQueryTextSubmit(String query) {
                return false;
            }

            @Override
            public boolean onQueryTextChange(String newText) {
                List<Country> filteredList = new ArrayList<>();
                if (countriesList != null) {
                    for (int i = 0; i < countriesList.size(); i++) {
                        if (countriesList.get(i).getName().length() >= newText.length()) {
                            String currentName = countriesList.get(i).getName().substring(0, newText.length());
                            if (currentName.equalsIgnoreCase(newText)) {

                                filteredList.add(countriesList.get(i));
                            }
                        }
                    }
                    countryAdapter.setCountriesList(filteredList);
                }

                return true;
            }
        });


    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(getActivity());
        countryAdapter = new CountriesRecyclerViewAdapter(getActivity(), new CountriesRecyclerViewAdapter.onItemClickListener() {
            @Override
            public void onClick(Country type) {
                cameraViewModel.selectedCountry(type);
                cameraViewModel.setDismissCountryDialogMutableLiveData(true);
            }
        });

        recyclerView.setAdapter(countryAdapter);
        recyclerView.setLayoutManager(linearLayoutManager);

        cameraViewModel.getCountriesListMutableLiveData().observe(this, response ->
        {
            if (response != null) {
                countriesList = response.data;
                countryAdapter.addAll(countriesList);
                countryAdapter.notifyDataSetChanged();
            }
        });
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setCancelable(true);
        View view = inflater.inflate(R.layout.fragment_countries_selection, container, true);
        recyclerView = view.findViewById(R.id.countries_recycler_view);


        return view;


    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        recyclerView.setAdapter(null);
        recyclerView.setLayoutManager(null);
        recyclerView = null;
    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener {
        // TODO: Update argument type and name
        void onFragmentInteraction(Uri uri);
    }
}
