package com.idenfy.idenfySdk.UI.InitialAgreementView;

import android.annotation.SuppressLint;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatButton;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Spinner;

import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.CountriesSelectionFragment;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.CountryAdapter;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfySdk.R;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;

import java.util.ArrayList;
import java.util.Objects;


/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link InitialAgreementFragmnet.OnFragmentInteractionListener} interface
 * to handle interaction events.
 * Use the {@link InitialAgreementFragmnet#newInstance} factory method to
 * create an instance of this fragment.
 */
public class InitialAgreementFragmnet extends Fragment {
    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;
    private Spinner countriesSpinner;
    CountryAdapter countryAdapter;
    ArrayList<Country> countriesList;
    ConstraintLayout countriesSpinnerLayout;
    CameraViewModel cameraViewModel;
    Button countriesSelectionButton;

    private OnFragmentInteractionListener mListener;
    protected SparseArray<ArrayList<Country>> mCountriesMap = new SparseArray<ArrayList<Country>>();
    private CountriesSelectionFragment countriesSelectionFragment;
    private String countryFromIdString;
    private AppCompatButton submitOkButton;
    private String COUNTRIES_SELECTION_DIALOG_FRAGMENT = "COUNTRIES_SELECTION_DIALOG_FRAGMENT";

    CheckBox checkBox, checkBox2;
    private View rootView;


    public InitialAgreementFragmnet() {
        // Required empty public constructor
    }

    // TODO: Rename and change types and number of parameters
    public static InitialAgreementFragmnet newInstance(String param1, String param2) {
        InitialAgreementFragmnet fragment = new InitialAgreementFragmnet();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        cameraViewModel = ViewModelProviders.of(requireActivity()).get(CameraViewModel.class);
        cameraViewModel.setInitialAgreementButtonAvailability(false);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    @SuppressLint("RestrictedApi")
    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        countriesSelectionButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                FragmentManager fm = Objects.requireNonNull(getActivity()).getSupportFragmentManager();
                Fragment fragment = fm.findFragmentByTag(COUNTRIES_SELECTION_DIALOG_FRAGMENT);
                if (fragment == null) {
                    FragmentTransaction ft = fm.beginTransaction();
                    countriesSelectionFragment = CountriesSelectionFragment.newInstance();
                    countriesSelectionFragment.setTargetFragment(InitialAgreementFragmnet.this,
                            5);
                    countriesSelectionFragment.show(ft, COUNTRIES_SELECTION_DIALOG_FRAGMENT);
                }
            }
        });
        if (getActivity() != null) {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementButtonColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_2
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_3
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementButtonColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_4
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_5
                    )));
            checkBox.setText(builder);
        }

        Resource<String> countryFromIdResource = cameraViewModel.getCountryFromIPLiveDataAndDecideToShowFragment().getValue();
        if (countryFromIdResource != null && countryFromIdResource.status == Status.SUCCESS) {
            countryFromIdString = countryFromIdResource.data;
        }
        countriesList = new ArrayList<>();
        countryAdapter = new CountryAdapter(getActivity());

        cameraViewModel.getSelectedCountryLiveData().observe(this, response ->
        {
            if (countriesSelectionFragment != null) {
                if (response != null) {

                    countriesSelectionButton.setCompoundDrawablesWithIntrinsicBounds(response.getResId(), 0, 0, 0);
                    countriesSelectionButton.setText(response.getName());
                    cameraViewModel.countrySelected = true;
                    if (cameraViewModel.checkBoxChecked && cameraViewModel.countrySelected && cameraViewModel.
                            check2BoxChecked)
                        cameraViewModel.setInitialAgreementButtonAvailability(true);
                    else
                        cameraViewModel.setInitialAgreementButtonAvailability(false);
                }

            }

        });
        cameraViewModel.getInitialAgreementButtonAvailability().observe(this, isAvailable ->
        {
            if (isAvailable != null) {
                if (isAvailable) {
                    submitOkButton.setEnabled(true);
                    submitOkButton.setBackgroundColor(getResources().getColor(R.color.idenfyColorAccent));
                    submitOkButton.setSupportBackgroundTintList(ContextCompat.getColorStateList(getContext(),
                            R.color.idenfyColorAccent));
                } else {
                    submitOkButton.setBackgroundColor(getResources().getColor(R.color.colorAccentIdenfyDarkgrey));
                    submitOkButton.setSupportBackgroundTintList(ContextCompat.getColorStateList(getContext(),
                            R.color.colorAccentIdenfyDarkgrey));
                }
            }
        });
        cameraViewModel.getDismissCountryDialogLiveData().observe(this, response ->
        {
            if (response != null) {
                if (response) {
                    if (countriesSelectionFragment != null)
                        countriesSelectionFragment.dismiss();
                }
            }


        });
        cameraViewModel.getCountrySetForDocumentMutableLiveData().observe(this, responseBodyResource ->
        {
            if (responseBodyResource != null) {
                if (responseBodyResource.status == Status.SUCCESS) {
                    cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(false);
                }
            }
        });
        checkBox2.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                cameraViewModel.check2BoxChecked = isChecked;
                if (cameraViewModel.checkBoxChecked && cameraViewModel.countrySelected && cameraViewModel.
                        check2BoxChecked)
                    cameraViewModel.setInitialAgreementButtonAvailability(true);
                else
                    cameraViewModel.setInitialAgreementButtonAvailability(false);
            }
        });
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                cameraViewModel.checkBoxChecked = isChecked;
                if (cameraViewModel.checkBoxChecked && cameraViewModel.countrySelected && cameraViewModel.
                        check2BoxChecked)
                    cameraViewModel.setInitialAgreementButtonAvailability(true);
                else
                    cameraViewModel.setInitialAgreementButtonAvailability(false);
            }
        });
        submitOkButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Boolean isAvailable = cameraViewModel.getInitialAgreementButtonAvailability().getValue();
                {
                    if (isAvailable != null) {
                        if (isAvailable) {
                            cameraViewModel.setCountryForDocument(cameraViewModel.getSelectedCountryLiveData().getValue());
                            cameraViewModel.startSession();
                        } else {
                            if (!cameraViewModel.countrySelected) {
                                Snackbar mySnackbar = Snackbar.make(rootView,
                                        R.string.select_your_document_issuing_country_message, Snackbar.LENGTH_SHORT);
                                mySnackbar.show();
                            }
                        }
                    }
                }
            }
        });
    }

    private SpannableString setColoredSpan(ForegroundColorSpan color, String string) {
        SpannableString spanStr = new SpannableString(string);
        spanStr.setSpan(color, 0, spanStr.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return spanStr;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        checkBox = view.findViewById(R.id.checkBox);
        checkBox.setTextColor(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor));
        checkBox2 = view.findViewById(R.id.checkBox2);
        checkBox2 = view.findViewById(R.id.checkBox2);
        checkBox2.setText(Html.fromHtml(getString(R.string.first_checkbox)));
        submitOkButton = view.findViewById(R.id.submitButton);
        countriesSelectionButton = view.findViewById(R.id.countries_button_selection);
        countriesSpinnerLayout = view.findViewById(R.id.countries_spinner_layout);

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        countriesSelectionFragment.dismiss();
        countriesSelectionFragment = null;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.fragment_initial_agreement_fragmnet, container,
                false);
        return rootView;
    }

    // TODO: Rename method, update argument and hook method into UI event
    public void onButtonPressed(Uri uri) {
        if (mListener != null) {
            mListener.onFragmentInteraction(uri);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        Log.d("idenfy2.0", "onPauseInitial");
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            mListener = (OnFragmentInteractionListener) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragmentInteractionListener");
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mListener = null;
    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener {
        // TODO: Update argument type and name
        void onFragmentInteraction(Uri uri);
    }
}
