package com.idenfy.idenfySdk.UI.AuthenticationResultView;

import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatDelegate;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.ErrorMessage;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.helpers.ErrorsHelper;
import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfySdk.R;

import java.util.List;
import java.util.Locale;


/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link OnFragmentInteractionListener} interface
 * to handle interaction events.
 * Use the {@link AuthenticationResultFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class AuthenticationResultFragment extends Fragment implements View.OnClickListener {
    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    private OnAuthenticationResultFragmentClosed mFragmentClosedListener;
    private RetakeStepsListListener retakeStepsListListener;
    private CameraViewModel cameraViewModel;
    private boolean buttonClicked;
    private Button btnClose;
    //   HorizontalStepView horizontalStepView;

    public AuthenticationResultFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param param1 Parameter 1.
     * @param param2 Parameter 2.
     * @return A new instance of fragment AuthenticationResultFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static AuthenticationResultFragment newInstance(String param1, String param2) {
        AuthenticationResultFragment fragment = new AuthenticationResultFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        cameraViewModel = ViewModelProviders.of(getActivity()).get(CameraViewModel.class);
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }


    ImageView backPhotoPlaceHolder;
    ImageView frontPhotoPlaceHolder;
    ImageView facePhotoPlaceHolder;
    ProgressBar backProgressBar;
    ProgressBar faceProgressBar;
    ProgressBar frontProgressBar;
    private TextView titleTextView;
    private TextView title2TextView;
    private TextView descriptionTextView;
    private ProgressBar materialProgressBar;


    private void initializeUI(View view) {
        backPhotoPlaceHolder = view.findViewById(R.id.back_pr_bar_place_holder);
        materialProgressBar = view.findViewById(R.id.horizontal_progress_bar);
        frontPhotoPlaceHolder = view.findViewById(R.id.front_pr_bar_place_holder);
        facePhotoPlaceHolder = view.findViewById(R.id.face_pr_bar_place_holder);
        titleTextView = view.findViewById(R.id.titleTextView);
        descriptionTextView = view.findViewById(R.id.descriptionTextView);
        backProgressBar = view.findViewById(R.id.progressBarBack);
        faceProgressBar = view.findViewById(R.id.progressBarFace);
        frontProgressBar = view.findViewById(R.id.progressBarFront);
        btnClose = view.findViewById(R.id.btnClose);
        backPhotoPlaceHolder = view.findViewById(R.id.back_pr_bar_place_holder);
        materialProgressBar = view.findViewById(R.id.horizontal_progress_bar);
        frontPhotoPlaceHolder = view.findViewById(R.id.front_pr_bar_place_holder);
        facePhotoPlaceHolder = view.findViewById(R.id.face_pr_bar_place_holder);
        titleTextView = view.findViewById(R.id.titleTextView);
        descriptionTextView = view.findViewById(R.id.descriptionTextView);
        backProgressBar = view.findViewById(R.id.progressBarBack);
        faceProgressBar = view.findViewById(R.id.progressBarFace);
        frontProgressBar = view.findViewById(R.id.progressBarFront);
        faceProgressBar.setVisibility(View.VISIBLE);
        btnClose = view.findViewById(R.id.btnClose);
        btnClose.setVisibility(View.INVISIBLE);
    }

    private void observeAuthenticationResponse() {
        cameraViewModel.authneticationResultResponse.observe(this, response ->
        {
            if (response != null) {
                if (response.status == Status.LOADING) {
                    startProgressBars();
                } else if (response.status == Status.SUCCESS) {

                    if (response.data != null) {
                        if (cameraViewModel.currentDocument.getValue() == DocumentType.PASSPORT)
                            handleStepsLoadingPassport(response.data);
                        else if (cameraViewModel.currentDocument.getValue() == DocumentType.ID_CARD_FRONT)
                            handleStepsLoading(response.data);
                        if (response.data.getProcessingStatus().equalsIgnoreCase("FINISHED")) {

                            if (response.data.getIdentificationStatus().equalsIgnoreCase("APPROVED")) {
                                materialProgressBar.setVisibility(View.INVISIBLE);
                                showSuccess("");
                            } else {
                                materialProgressBar.setVisibility(View.INVISIBLE);
                                String sDefSystemLanguage = Locale.getDefault().getLanguage();
                                handleErrorMessage(sDefSystemLanguage, response.data.getErrorMessage());
                            }
                        }
                    }
                }
            }
        });
    }

    private void observeIdenfyError() {
        cameraViewModel.getIdenfyError().observe(this, response ->
        {
            if (response != null) {
                showIdenfyError(ErrorsHelper.getErrrorMessageFromIdentifier(getActivity(), response.getIdenfyErrorResponse().getIdentifier()));
            }
        });
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = null;
        if (cameraViewModel.currentDocument.getValue() == DocumentType.PASSPORT) {
            view = inflater.inflate(R.layout.authentication_resut_with_steps_passport, container, false);
        } else {
            view = inflater.inflate(R.layout.authentication_resut_with_steps_id, container, false);
        }
        initializeUI(view);
        observeAuthenticationResponse();
        observeIdenfyError();
        return view;
    }

    private void handleStepsLoading(AuthenticationResultResponse data) {
        if (data.getRetakeSteps().getFRONT() != null) {
            if (data.getRetakeSteps().getFRONT()) {
                frontProgressBar.setVisibility(View.INVISIBLE);
                frontPhotoPlaceHolder.setImageResource(R.drawable.ic_success);
            } else {
                List<DocumentType> documentTypeList = cameraViewModel.retakeDocumentsList.getValue();
                if (cameraViewModel.currentDocument.getValue() == DocumentType.ID_CARD_FRONT) {
                    if (documentTypeList != null && !documentTypeList.contains(DocumentType.ID_CARD_FRONT))
                        documentTypeList.add(DocumentType.ID_CARD_FRONT);
                    cameraViewModel.setUploadsFinishedFalse(DocumentType.ID_CARD_FRONT);
                } else {
                    if (documentTypeList != null && !documentTypeList.contains(DocumentType.PASSPORT))
                        documentTypeList.add(DocumentType.PASSPORT);
                    cameraViewModel.setUploadsFinishedFalse(DocumentType.PASSPORT);
                }
                cameraViewModel.retakeDocumentsList.postValue(documentTypeList);
                cameraViewModel.setIsBackFotoapparatCamera(true);
                makeProgressBarsInvisible();
                frontPhotoPlaceHolder.setImageResource(R.drawable.ic_error);

            }

        }
        if (data.getRetakeSteps().getBACK() != null) {
            if (data.getRetakeSteps().getBACK()) {
                backProgressBar.setVisibility(View.INVISIBLE);
                backPhotoPlaceHolder.setImageResource(R.drawable.ic_success);
            } else {
                List<DocumentType> documentTypeList = cameraViewModel.retakeDocumentsList.getValue();
                if (documentTypeList != null && !documentTypeList.contains(DocumentType.ID_CARD_BACK))
                    documentTypeList.add(DocumentType.ID_CARD_BACK);
                cameraViewModel.setIsBackFotoapparatCamera(true);
                cameraViewModel.retakeDocumentsList.postValue(documentTypeList);
                cameraViewModel.setUploadsFinishedFalse(DocumentType.ID_CARD_BACK);
                makeProgressBarsInvisible();
                backPhotoPlaceHolder.setImageResource(R.drawable.ic_error);
            }
        } else {

        }

        if (data.getRetakeSteps().getFACE() != null) {
            if (data.getRetakeSteps().getFACE()) {
                faceProgressBar.setVisibility(View.INVISIBLE);
                facePhotoPlaceHolder.setImageResource(R.drawable.ic_success);
            } else {
                List<DocumentType> documentTypeList = cameraViewModel.retakeDocumentsList.getValue();
                if (documentTypeList != null && !documentTypeList.contains(DocumentType.FACE_PHOTO))
                    documentTypeList.add(DocumentType.FACE_PHOTO);
                if (documentTypeList != null) {
                    if (documentTypeList.contains(DocumentType.ID_CARD_FRONT) ||
                            documentTypeList.contains(DocumentType.ID_CARD_BACK) ||
                            documentTypeList.contains(
                                    DocumentType.PASSPORT
                            )) {

                    } else {
                        cameraViewModel.setIsBackFotoapparatCamera(false);
                    }
                }

                cameraViewModel.retakeDocumentsList.postValue(documentTypeList);
                cameraViewModel.setUploadsFinishedFalse(DocumentType.FACE_PHOTO);
                facePhotoPlaceHolder.setImageResource(R.drawable.ic_error);
                makeProgressBarsInvisible();
            }
        }
    }

    private void handleStepsLoadingPassport(AuthenticationResultResponse data) {
        if (data.getRetakeSteps().getFRONT() != null) {
            if (data.getRetakeSteps().getFRONT()) {
                frontProgressBar.setVisibility(View.INVISIBLE);
                frontPhotoPlaceHolder.setImageResource(R.drawable.ic_success);
            } else {
                List<DocumentType> documentTypeList = cameraViewModel.retakeDocumentsList.getValue();
                if (cameraViewModel.currentDocument.getValue() == DocumentType.ID_CARD_FRONT) {
                    if (documentTypeList != null && !documentTypeList.contains(DocumentType.ID_CARD_FRONT))
                        documentTypeList.add(DocumentType.ID_CARD_FRONT);
                    cameraViewModel.setUploadsFinishedFalse(DocumentType.ID_CARD_FRONT);

                } else {
                    if (documentTypeList != null && !documentTypeList.contains(DocumentType.PASSPORT))
                        documentTypeList.add(DocumentType.PASSPORT);
                    cameraViewModel.setUploadsFinishedFalse(DocumentType.PASSPORT);
                }
                cameraViewModel.retakeDocumentsList.postValue(documentTypeList);
                cameraViewModel.setIsBackFotoapparatCamera(true);
                frontProgressBar.setVisibility(View.INVISIBLE);
                faceProgressBar.setVisibility(View.INVISIBLE);
                frontPhotoPlaceHolder.setImageResource(R.drawable.ic_error);

            }

        }
        if (data.getRetakeSteps().getBACK() != null) {
            if (data.getRetakeSteps().getBACK()) {
            } else {
                List<DocumentType> documentTypeList = cameraViewModel.retakeDocumentsList.getValue();
                if (documentTypeList != null && !documentTypeList.contains(DocumentType.ID_CARD_BACK))
                    documentTypeList.add(DocumentType.ID_CARD_BACK);
                cameraViewModel.setIsBackFotoapparatCamera(true);
                cameraViewModel.retakeDocumentsList.postValue(documentTypeList);
                cameraViewModel.setUploadsFinishedFalse(DocumentType.ID_CARD_BACK);
                frontProgressBar.setVisibility(View.INVISIBLE);
                faceProgressBar.setVisibility(View.INVISIBLE);
            }
        } else {

        }

        if (data.getRetakeSteps().getFACE() != null) {
            if (data.getRetakeSteps().getFACE()) {
                faceProgressBar.setVisibility(View.INVISIBLE);
                facePhotoPlaceHolder.setImageResource(R.drawable.ic_success);
            } else {
                List<DocumentType> documentTypeList = cameraViewModel.retakeDocumentsList.getValue();
                if (documentTypeList != null && !documentTypeList.contains(DocumentType.FACE_PHOTO))
                    documentTypeList.add(DocumentType.FACE_PHOTO);
                if (documentTypeList != null) {
                    if (documentTypeList.contains(DocumentType.ID_CARD_FRONT) ||
                            documentTypeList.contains(DocumentType.ID_CARD_BACK) ||
                            documentTypeList.contains(
                                    DocumentType.PASSPORT
                            )) {

                    } else {
                        cameraViewModel.setIsBackFotoapparatCamera(false);
                    }
                }

                cameraViewModel.retakeDocumentsList.postValue(documentTypeList);
                cameraViewModel.setUploadsFinishedFalse(DocumentType.FACE_PHOTO);
                facePhotoPlaceHolder.setImageResource(R.drawable.ic_error);
                frontProgressBar.setVisibility(View.INVISIBLE);
                faceProgressBar.setVisibility(View.INVISIBLE);
            }
        }
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (IdenfyController.getInstance().getSettings() != null) {

        }
    }

    public void startProgressBars() {
        if (backProgressBar != null)
            backProgressBar.setVisibility(View.VISIBLE);
        if (frontProgressBar != null)
            frontProgressBar.setVisibility(View.VISIBLE);
        if (faceProgressBar != null)
            faceProgressBar.setVisibility(View.VISIBLE);


    }

    public void showSuccess(String response) {


        materialProgressBar.setVisibility(View.INVISIBLE);
        titleTextView.setText(getResources().getString(R.string.data_approved));
        cameraViewModel.authenticationSuccessForClosing.postValue(true);
    }

    @Override
    public void onStop() {
        super.onStop();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        btnClose = null;
    }

    public void showError(String response) {


        btnClose.setVisibility(View.VISIBLE);
        btnClose.setText(R.string.thank_repeat);
        titleTextView.setText(R.string.data_failed);
        descriptionTextView.setVisibility(View.VISIBLE);
        descriptionTextView.setText(response);
        btnClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                buttonClicked = true;
                if (retakeStepsListListener != null) {
                    cameraViewModel.shouldDeleteCustomViews = true;
                    retakeStepsListListener.onRetakeStepsList(true);
                }
            }
        });
    }

    private void makeProgressBarsInvisible() {
        if (backProgressBar != null)
            backProgressBar.setVisibility(View.INVISIBLE);
        if (frontProgressBar != null)
            frontProgressBar.setVisibility(View.INVISIBLE);
        if (faceProgressBar != null)
            faceProgressBar.setVisibility(View.INVISIBLE);
    }

    public void showIdenfyError(String response) {
        makeProgressBarsInvisible();
        btnClose.setVisibility(View.INVISIBLE);
        materialProgressBar.setVisibility(View.INVISIBLE);
        facePhotoPlaceHolder.setImageResource(R.drawable.ic_error);
        if (backPhotoPlaceHolder != null)
            backPhotoPlaceHolder.setImageResource(R.drawable.ic_error);
        if (frontPhotoPlaceHolder != null)
            frontPhotoPlaceHolder.setImageResource(R.drawable.ic_error);
        titleTextView.setText(R.string.data_failed);
        descriptionTextView.setVisibility(View.VISIBLE);
        descriptionTextView.setText(response);
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    private void handleErrorMessage(String sDefSystemLanguage, ErrorMessage errorMessage) {
        switch (sDefSystemLanguage) {
            case "en":
                showError(errorMessage.getEn());
                break;
            case "lt":
                showError(errorMessage.getLt());
                break;
            case "ru":
                showError(errorMessage.getRu());
                break;
            default:
                showError(errorMessage.getEn());
                break;
        }
    }

    @Override
    public void onAttach(Context context) {
        if (context instanceof OnAuthenticationResultFragmentClosed) {
            mFragmentClosedListener = (OnAuthenticationResultFragmentClosed) context;
        }
        if (context instanceof RetakeStepsListListener) {
            retakeStepsListListener = (RetakeStepsListListener) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    @Override
    public void onClick(View button) {
        switch (button.getId()) {
        }

    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener {
        // TODO: Update argument type and name
        void onFragmentInteraction(Uri uri);
    }

    public interface OnAuthenticationResultFragmentClosed {
        // TODO: Update argument type and name
        public void onAuthenticationResultFragmentClosed(boolean closed);
    }

    public interface RetakeStepsListListener {
        // TODO: Update argument type and name
        public void onRetakeStepsList(Boolean value);
    }
}
