package com.idenfy.idenfySdk.UI.CameraView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.idenfy.idenfySdk.UI.CustomViews.OvalFace;
import com.idenfy.idenfySdk.UI.CustomViews.Rectangle;
import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfySdk.R;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraDisplayHelpers;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraViewSize;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.UI.UIHelpers.DpToPixelConverter;

import java.util.Objects;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.error.CameraErrorListener;
import io.fotoapparat.exception.camera.CameraException;
import io.fotoapparat.log.LoggersKt;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.selector.LensPositionSelectorsKt;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;

import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.back;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

/**
 * A simple {@link Fragment} subclass.
 * create an instance of this fragment.
 */
public class CameraNewFragment extends Fragment {

    public static final String TAG = CameraNewFragment.class.getSimpleName();
    public Fotoapparat fotoapparat;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    ConstraintLayout imageInfoLayout;
    TextView documentTitleTutorial;
    DocumentType currentDocumentType;
    CustomFrameProcessor.OnPictureListener onPictureListener;


    private FloatingActionButton takePictureButton;
    private CustomFrameProcessor frameProcessor;
    private ImageView imageView;
    private View rootView;
    private ImageView imageViewFullScreenResult;
    private ImageView imageViewResult;
    private Button recreateButton;
    private Button nextButton;
    private boolean isBackCamera;
    ImageView faceImage;
    ImageView backImage;
    TextView backButton;
    private int horizontalMarginNew;
    private int verticalMarginNew;
    private int squareImageResultParams;

    RelativeLayout imageViewParent;

    private CameraConfiguration cameraConfiguration;
    private TextView imageViewResultTitle;
    private boolean nextButtonPressed;
    private boolean takePictureButtonPressed;
    private boolean recreateButtonPressed;
    private ConstraintLayout constraint_main_root;
    private int leftMargin;
    private boolean isFirstTime;
    private int verticalMargin;
    private RelativeLayout customShapes;

    private OnCameraClosedFragment mFragmentClosedListener;
    private int rectangleLeft;
    private int rectangleTop;
    private int rectangleRight;
    private int rectangleBottom;
    private int heightOfImage;
    private int yCoordinateOfHeightStart;
    private int widthOfImage;
    private int xCoordinateOfWidthStart;
    private final int rectangeMargin = 5;

    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public CameraNewFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            frameProcessor = new CustomFrameProcessor(requireActivity());
        }
        setFotoapparatCameraSettins(frameProcessor);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);
        cameraViewModel.getIsBackFotoapparatCamera().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean isBack) {
                if (isBack != null) {
                    isBackCamera = isBack;
                    CameraNewFragment.this.setCameraSettings();
                }
            }
        });

    }

    private void setCameraSettings() {


        if (fotoapparat != null) {
            fotoapparat.switchTo(isBackCamera ? LensPositionSelectorsKt.back() :
                    LensPositionSelectorsKt.front(), cameraConfiguration);


        }

    }

    private void setFotoapparatCameraSettins(FrameProcessor frameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(PreviewFpsRangeSelectorsKt.highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable(
                        continuousFocusPicture(),
                        autoFocus(),
                        fixed()
                ))
                .build();
    }

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        constraint_main_root = rootView.findViewById(R.id.previewHolder);
        documentTitleTutorial = rootView.findViewById(R.id.showedDocumentTitle);
        imageViewResultTitle = rootView.findViewById(R.id.showedDocumentTitle1);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage);
        customShapes = rootView.findViewById(R.id.custom_shapes);
        imageView = rootView.findViewById(R.id.imageView);
        faceImage = rootView.findViewById(R.id.faceImage);
        backButton = rootView.findViewById(R.id.backButton);
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult);
        recreateButton = rootView.findViewById(R.id.recreateButton);
        imageViewResult = rootView.findViewById(R.id.imageViewResult);
        nextButton = rootView.findViewById(R.id.nextButton);
        imageViewParent = rootView.findViewById(R.id.layout);

    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.fragment_camera_preview, container, false);

        initializeUI(rootView);

        return rootView;
    }

    private void observeDocumentType() {
        cameraViewModel.getDocumentTypeMutableLiveData().observe(this, new Observer<DocumentType>() {
            @Override
            public void onChanged(@Nullable DocumentType response) {

                if (response != null) {
                    setupDocumentTitle(response);
                    CameraNewFragment.this.setupDocumentView(response);

                }
            }
        });
    }

    private void setupDocumentTitle(DocumentType response) {
        Integer titleId;
        currentDocumentType = response;
        titleId = CameraNewFragment.this.setupTitles(response);
        documentTitleTutorial.setText(titleId);
    }

    private void observeUI() {
        cameraViewModel.getDocumentTutorialTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });
        cameraViewModel.getImageViewResultTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null)
                    imageViewResultTitle.setTextColor(Color.parseColor(color));
            }
        });

        cameraViewModel.getImageViewResultTitleMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String s) {
                imageViewResultTitle.setText(s);
            }
        });
        cameraViewModel.getImageViewResult().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {

                if (response != null) {
                    imageViewResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getImageViewResultFullSize().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    imageViewFullScreenResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });


        cameraViewModel.getRecreateButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    recreateButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getShowImageLayoutVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageInfoLayout.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getNextButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    View view = getCustomShape();
                    if (view == null) {
                        return;
                    }
                    if (view instanceof Rectangle) {
                        Rectangle rectangle = (Rectangle) view;
                        DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                                response ? R.color.backArrowColor :
                                        R.color.idenfyCameraBackArrowPreviewColor));
                        rectangle.changeTransparentBackgroundVisibility(response ? false : true);
                        rectangle.invalidate();
                    }
                    nextButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getActionButtonVisibility().observe(this, new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCropShapeImageView().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getDocumentTutorialTitleVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    documentTitleTutorial.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    imageViewResultTitle.setVisibility(response ? View.INVISIBLE : View.VISIBLE);
                }
            }
        });
        cameraViewModel.getCameraViewVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    cameraView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        pictureButtonOnClickListener();
    }


    public void setupDocumentView(@Nullable DocumentType document) {
        if (document != DocumentType.FACE_PHOTO) {
            imageViewResultTitle.setTextColor(ContextCompat.getColor(Objects.requireNonNull(getActivity()), R.color.idenfyCameraResultsTitle));
            ViewTreeObserver vto = rootView.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                @Override
                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                        rootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                    }
                    else
                    {
                        rootView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                    }
                    int width = rootView.getWidth();
                    int height = rootView.getHeight();
                    RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, document != null ? document.getProportions() : 30f / 19f);
                    if (visibleArea == null) {
                        setupImageView(document);
                    } else {
                        final double xPositionRatio = visibleArea.left / width;
                        final double yPositionRatio = visibleArea.top / height;
                        if (imageView != null)
                            setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, document);
                    }

                }
            });
        } else {
            imageViewResultTitle.setTextColor(ContextCompat.getColor(Objects.requireNonNull(getActivity()), R.color.idenfyCameraInformationTitle));
            int width = rootView.getWidth();
            int height = rootView.getHeight();
            RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, document != null ? document.getProportions() : 30f / 19f);
            if (visibleArea == null) {
                setupImageView(document);
            } else {
                final double xPositionRatio = visibleArea.left / width;
                final double yPositionRatio = visibleArea.top / height;
                if (imageView != null)
                    setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, document);
            }
        }
    }


    private void setupImageViewWithScalledImage(final double xPositionRatio, final double yPositionRatio,
                                                DocumentType documentType) {
        if (documentType == DocumentType.ID_CARD_FRONT || documentType == DocumentType.PASSPORT || documentType == DocumentType.ID_CARD_BACK) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) imageView.getLayoutParams();
            final RelativeLayout parent = (RelativeLayout) imageView.getParent();
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            int horizontalMargin = (int) (parent.getWidth() * xPositionRatio);
            int verticalMargin = (int) (parent.getHeight() * yPositionRatio);
            params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
            imageView.setLayoutParams(params);
            if (cameraViewModel.shouldDeleteCustomViews) {
                deleteOldParentViews();
                cameraViewModel.shouldDeleteCustomViews = false;
            }
            if (customShapes.getChildAt(0) == null) {

                Rectangle rectangle = drawRectangle(parentWidth, parentHeight, horizontalMargin, verticalMargin);
                customShapes.addView(rectangle, 0);
            }
            setupValuesForCropping(verticalMargin, horizontalMargin, parentHeight, parentWidth);
        }

    }

    private void setupValuesForCropping(int verticalMargin, int horizontalMargin, int parentHeight, int parentWidth) {
        yCoordinateOfHeightStart = verticalMargin - horizontalMargin;
        heightOfImage = parentHeight - verticalMargin * 2 + horizontalMargin * 2;
        widthOfImage = parentWidth;
        xCoordinateOfWidthStart = 0;
    }

    private Rectangle drawRectangle(int parentWidth, int parentHeight, int horizontalMargin, int verticalMargin) {

        rectangleLeft = parentWidth - horizontalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleRight = horizontalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleBottom = parentHeight - verticalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleTop = verticalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        Rectangle rectangle = new Rectangle(getActivity(),
                rectangleLeft,
                rectangleTop,
                rectangleRight,
                rectangleBottom);
        if (this.rectangleLeft > this.rectangleRight) {
            int c = this.rectangleLeft;
            int k = this.rectangleRight;
            this.rectangleRight = c;
            this.rectangleLeft = k;
        }
        return rectangle;
    }

    private void deleteOldParentViews() {
        if (!(customShapes.getChildAt(0) == null))
            customShapes.removeViewAt(0);

    }

    private View getCustomShape() {
        if (!(customShapes.getChildAt(0) == null)) {
            return customShapes.getChildAt(0);
        }
        return null;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        recreateButtonPressed = false;
        nextButtonPressed = false;
        takePictureButtonPressed = false;
        backButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        observeDocumentType();

    }

    private void observeButtonsAvailability() {
        cameraViewModel.getNextButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    nextButton.setEnabled(response);

                }
            }
        });
        cameraViewModel.getRecreateButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    recreateButton.setEnabled(aBoolean);
            }
        });
        cameraViewModel.getTakePictureButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    takePictureButton.setEnabled(aBoolean);
            }
        });
    }


    private void setupImageView(DocumentType documentType) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) imageView.getLayoutParams();
        final RelativeLayout parent = (RelativeLayout) imageView.getParent();
        int horizontalMargin = (int) (parent.getWidth());
        int verticalMargin = (int) (parent.getHeight());
        params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
        imageView.setLayoutParams(params);
        deleteOldParentViews();
        if (documentType == DocumentType.FACE_PHOTO) {
            View view = new OvalFace(requireActivity());
            customShapes.addView(view, 0);
        }


    }

    private void pictureButtonOnClickListener() {
        takePictureButton.setEnabled(false);
        takePictureButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(false);
                takePicture();
                takePictureButtonPressed = true;

            }
        });


    }

    public void takePicture() {
        if (fotoapparat != null) {
            frameProcessor.takePicture(new CustomFrameProcessor.OnPictureListener() {

                @Override
                public void OnPictureTaken(Bitmap bitmap, int rotation, String encoded) {

                    BitmapPhoto photo = new BitmapPhoto(bitmap, rotation);
                    showPhoto(photo);
                }
            });
        }
    }

    public CameraViewSize getCameraPreviewSize() {

        return new CameraViewSize(cameraView.getWidth(), cameraView.getHeight());
    }


    public void showPhoto(@NonNull final BitmapPhoto bitmapPhoto) {
        if (cameraView != null) {
            requireActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    show(BitmapPhotoCropper.
                            cropPhotoWithPaddings(bitmapPhoto, getCameraPreviewSize(), new RectF(xCoordinateOfWidthStart, yCoordinateOfHeightStart, widthOfImage, heightOfImage),
                                    currentDocumentType), currentDocumentType);


                }
            });


        }
    }

    public void show(final Bitmap bitmap, DocumentType type) {

        cameraViewModel.setShowImageLayoutVisibility(true);
        cameraViewModel.setImageViewResultTitleMutableLiveData(type);
        nextButtonPressed = false;
        recreateButtonPressed = false;
        if (type == DocumentType.FACE_PHOTO) {
            cameraViewModel.setImageViewResultFullSize(true);
            imageViewFullScreenResult.setImageBitmap(bitmap);
        } else {
            cameraViewModel.setImageViewResult(true);
            ViewGroup.LayoutParams params = imageViewResult.getLayoutParams();
            params.width = rectangleRight - rectangleLeft;
            params.height = rectangleBottom - rectangleTop;
            imageViewResult.setLayoutParams(params);
            imageViewResult.setImageBitmap(bitmap);
        }
        cameraViewModel.setDocumentTutorialTitleVisibility(false);
        cameraViewModel.setActionButtonVisibility(false);
        cameraViewModel.setRecreateButtonVisibility(true);
        cameraViewModel.setNextButtonAvailability(true);
        cameraViewModel.setRecreateButtonAvailability(true);
        cameraViewModel.setNextButtonVisibility(true);


        recreateButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                if (!bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                recreateImage();
                recreateButtonPressed = true;
                takePictureButtonPressed = false;

            }
        });

        nextButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                nextStep(bitmap);
                nextButtonPressed = true;
                takePictureButtonPressed = false;
            }
        });
    }

    public void nextStep(Bitmap bitmap) {
        cameraViewModel.setupNewDocument(bitmap);

    }


    public void recreateImage() {
        cameraViewModel.changeDocument(currentDocumentType, true);
    }

    private Integer setupTitles(DocumentType documentType) {
        Integer titleName = -1;
        switch (documentType) {
            case PASSPORT:
                titleName = R.string.document_type_text;
                break;
            case ID_CARD_FRONT:
                titleName = R.string.document_type_id_card_front;
                break;
            case ID_CARD_BACK:
                titleName = R.string.document_type_id_card_back;
                break;
            case FACE_PHOTO:
                titleName = R.string.document_face_photo;
                break;
        }
        return titleName;
    }


    @Override
    public void onPause() {
        super.onPause();

    }

    @Override
    public void onStop() {
        super.onStop();
        if (frameProcessor != null) {
            frameProcessor = null;
        }
        if (fotoapparat != null) {
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    fotoapparat.stop();

                }
            }, 300);
        }


    }

    @Override
    public void onStart() {
        super.onStart();
        Activity activity = getActivity();
        if (isAdded() && activity != null) {

            if (frameProcessor == null)
                frameProcessor = new CustomFrameProcessor(requireActivity());
            if (fotoapparat != null) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        fotoapparat.start();
                    }
                }, 300);
            } else {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        setupCamera();

                    }
                }, 300);
            }

        }
    }

    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

    public void setupCamera() {

        Activity activity = getActivity();
        if (isAdded() && activity != null) {
            fotoapparat = Fotoapparat
                    .with(getActivity())
                    .into(cameraView)
                    .previewScaleType(ScaleType.CenterCrop)
                    .previewResolution(highestResolution())
                    .lensPosition(back())
                    .focusMode(firstAvailable(
                            continuousFocusPicture(),
                            autoFocus(),
                            fixed()
                    ))
                    .photoResolution(ResolutionSelectorsKt.highestResolution())
                    .frameProcessor(new CustomFrameProcessor(getActivity()))
                    .logger(
                            LoggersKt.logcat()
                    )
                    .cameraErrorCallback(new CameraErrorListener() {
                        @Override
                        public void onError(@NonNull CameraException e) {
                        }
                    })
                    .build();


            fotoapparat.start();
        }
    }

    public void onBackPressed() {
        mFragmentClosedListener.onCameraNewFragmentClosed(true);

    }


}
