package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.idenfySdk.R;

public class IdenfySettings implements Parcelable {

    private @NonNull
    String publicKey;
    private @NonNull
    String clientId;
    private @NonNull
    String firstName;
    private @NonNull
    String lastName;
    private String selectedCountry;
    private Typeface font;
    private @ColorRes
    int buttonTextColor;
    private @ColorRes
    int primaryTextColor;
    private @DrawableRes
    @ColorRes
    int backgroundDrawable;
    private @DrawableRes
    int successDrawable;
    private @DrawableRes
    int errorDrawable;
    private @DrawableRes
    int logoDrawable;
    private @Nullable
    String token;
    private @Nullable
    Boolean handleResultsChecking;

    public Typeface getIdenfyFont() {
        if (this.font != null) {
            return this.font;
        }
        return Typeface.DEFAULT_BOLD;
    }

    protected IdenfySettings(Parcel in) {
        publicKey = in.readString();
        clientId = in.readString();
        firstName = in.readString();
        lastName = in.readString();
        selectedCountry = in.readString();
        buttonTextColor = in.readInt();
        primaryTextColor = in.readInt();
        backgroundDrawable = in.readInt();
        successDrawable = in.readInt();
        errorDrawable = in.readInt();
        logoDrawable = in.readInt();
        token = in.readString();
        byte tmpHandleResultsChecking = in.readByte();
        handleResultsChecking = tmpHandleResultsChecking == 0 ? null : tmpHandleResultsChecking == 1;
    }

    public static final Creator<IdenfySettings> CREATOR = new Creator<IdenfySettings>() {
        @Override
        public IdenfySettings createFromParcel(Parcel in) {
            return new IdenfySettings(in);
        }

        @Override
        public IdenfySettings[] newArray(int size) {
            return new IdenfySettings[size];
        }
    };

    @Nullable
    public Boolean getHandleResultsChecking() {
        return handleResultsChecking;
    }

    public IdenfySettings(@NonNull String token, @NonNull Context context) {
        this("", "", "", "", "LTU", context);
        this.token = token;
    }

    public IdenfySettings(@NonNull String publicKey, @NonNull String clientId,
                          @NonNull String firstName, @NonNull String lastName,
                          @NonNull String selectedCountry, @NonNull Context context
    ) {
        this.publicKey = publicKey;
        this.clientId = clientId;
        this.firstName = firstName;
        this.lastName = lastName;

        logoDrawable = R.drawable.idenfy_logo_new_good;
        token = null;
    }


    @Nullable
    public String getToken() {
        return token;
    }

    @NonNull
    public Typeface getFont() {
        return font;
    }

    public String getSelectedCountry() {
        return selectedCountry;
    }

    public void setSelectedCountry(@NonNull String selectedCountry) {
        this.selectedCountry = selectedCountry;
    }

    void setHandleResultsChecking(boolean optionalHandeling) {
        this.handleResultsChecking = optionalHandeling;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(publicKey);
        dest.writeString(clientId);
        dest.writeString(firstName);
        dest.writeString(lastName);
        dest.writeString(selectedCountry);
        dest.writeInt(buttonTextColor);
        dest.writeInt(primaryTextColor);
        dest.writeInt(backgroundDrawable);
        dest.writeInt(successDrawable);
        dest.writeInt(errorDrawable);
        dest.writeInt(logoDrawable);
        dest.writeString(token);
        dest.writeByte((byte) (handleResultsChecking == null ? 0 : handleResultsChecking ? 1 : 2));
    }

    @Override
    public String toString() {
        return "IdenfySettings{" +
                "publicKey='" + publicKey + '\'' +
                ", clientId='" + clientId + '\'' +
                ", firstName='" + firstName + '\'' +
                ", lastName='" + lastName + '\'' +
                ", selectedCountry='" + selectedCountry + '\'' +
                ", font=" + font +
                ", buttonTextColor=" + buttonTextColor +
                ", primaryTextColor=" + primaryTextColor +
                ", backgroundDrawable=" + backgroundDrawable +
                ", successDrawable=" + successDrawable +
                ", errorDrawable=" + errorDrawable +
                ", logoDrawable=" + logoDrawable +
                ", token='" + token + '\'' +
                ", handleResultsChecking=" + handleResultsChecking +
                '}';
    }
}
