package com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class AuthenticationResultResponse implements Parcelable {

    @SerializedName("retakeSteps")
    @Expose
    private RetakeSteps retakeSteps;
    @SerializedName("processingStatus")
    @Expose
    private String processingStatus;
    @SerializedName("identificationStatus")
    @Expose
    private String identificationStatus;
    @SerializedName("errorMessage")
    @Expose
    private ErrorMessage errorMessage;
    @SerializedName("mrzFound")
    @Expose
    private Boolean mrzFound;
    @SerializedName("countryMatch")
    @Expose
    private Boolean countryMatch;
    @SerializedName("documentSupported")
    @Expose
    private Boolean documentSupported;
    @SerializedName("suspected")
    @Expose
    private Boolean suspected;

    protected AuthenticationResultResponse(Parcel in) {
        retakeSteps = in.readParcelable(RetakeSteps.class.getClassLoader());
        processingStatus = in.readString();
        identificationStatus = in.readString();
        errorMessage = in.readParcelable(ErrorMessage.class.getClassLoader());
        byte tmpMrzFound = in.readByte();
        mrzFound = tmpMrzFound == 0 ? null : tmpMrzFound == 1;
        byte tmpCountryMatch = in.readByte();
        countryMatch = tmpCountryMatch == 0 ? null : tmpCountryMatch == 1;
        byte tmpDocumentSupported = in.readByte();
        documentSupported = tmpDocumentSupported == 0 ? null : tmpDocumentSupported == 1;
        byte tmpSuspected = in.readByte();
        suspected = tmpSuspected == 0 ? null : tmpSuspected == 1;
    }

    public static final Creator<AuthenticationResultResponse> CREATOR = new Creator<AuthenticationResultResponse>() {
        @Override
        public AuthenticationResultResponse createFromParcel(Parcel in) {
            return new AuthenticationResultResponse(in);
        }

        @Override
        public AuthenticationResultResponse[] newArray(int size) {
            return new AuthenticationResultResponse[size];
        }
    };

    public RetakeSteps getRetakeSteps() {
        return retakeSteps;
    }

    public void setRetakeSteps(RetakeSteps retakeSteps) {
        this.retakeSteps = retakeSteps;
    }

    public String getProcessingStatus() {
        return processingStatus;
    }

    public void setProcessingStatus(String processingStatus) {
        this.processingStatus = processingStatus;
    }

    public String getIdentificationStatus() {
        return identificationStatus;
    }

    public void setIdentificationStatus(String identificationStatus) {
        this.identificationStatus = identificationStatus;
    }

    public ErrorMessage getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Boolean getMrzFound() {
        return mrzFound;
    }

    public void setMrzFound(Boolean mrzFound) {
        this.mrzFound = mrzFound;
    }

    public Boolean getCountryMatch() {
        return countryMatch;
    }

    public void setCountryMatch(Boolean countryMatch) {
        this.countryMatch = countryMatch;
    }

    public Boolean getDocumentSupported() {
        return documentSupported;
    }

    public void setDocumentSupported(Boolean documentSupported) {
        this.documentSupported = documentSupported;
    }

    public Boolean getSuspected() {
        return suspected;
    }

    public void setSuspected(Boolean suspected) {
        this.suspected = suspected;
    }

    @Override
    public String toString() {
        return "AuthenticationResultResponse{" +
                "retakeSteps=" + retakeSteps +
                ", processingStatus='" + processingStatus + '\'' +
                ", identificationStatus='" + identificationStatus + '\'' +
                ", errorMessage=" + errorMessage +
                ", mrzFound=" + mrzFound +
                ", countryMatch=" + countryMatch +
                ", documentSupported=" + documentSupported +
                ", suspected=" + suspected +
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(retakeSteps, flags);
        dest.writeString(processingStatus);
        dest.writeString(identificationStatus);
        dest.writeParcelable(errorMessage, flags);
        dest.writeByte((byte) (mrzFound == null ? 0 : mrzFound ? 1 : 2));
        dest.writeByte((byte) (countryMatch == null ? 0 : countryMatch ? 1 : 2));
        dest.writeByte((byte) (documentSupported == null ? 0 : documentSupported ? 1 : 2));
        dest.writeByte((byte) (suspected == null ? 0 : suspected ? 1 : 2));
    }
}