package com.idenfy.idenfySdk.UI.UIHelpers;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;

import java.lang.ref.WeakReference;

import io.fotoapparat.preview.Frame;
import io.fotoapparat.preview.FrameProcessor;

public class CustomFrameProcessor implements FrameProcessor {

    public CustomFrameProcessor(FragmentActivity fragmentActivity) {
        weakContext = new WeakReference<>(fragmentActivity);
    }


    public interface OnPictureListener {
        void OnPictureTaken(Bitmap bitmap, int rotation, String encoded);
    }

    private static @Nullable
    OnPictureListener listener = null;
    private static boolean takePicture = false;
    private boolean takingPicture = false;
    private static WeakReference<FragmentActivity> weakContext;

    @Override
    public void process(final @NonNull Frame frame) {
        if (weakContext.get() != null) {
            if (takePicture) {

                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                Bitmap bitmap = BitmapPhotoCropper.cropPhoto(frame.getImage(), frame.getSize().width, frame.getSize().height, weakContext.get());


                if (listener != null) {

                    listener.OnPictureTaken(bitmap, frame.getRotation(), "helo");

                    listener = null;
                }
            }
        }
        takePicture = false;
        takingPicture = false;
    }


    public void takePicture(OnPictureListener listener) {
        if (!takingPicture) {
            CustomFrameProcessor.listener = listener;
            takePicture = true;
        }
    }


}
