package com.idenfy.idenfySdk.UI.UIHelpers;

import android.graphics.PointF;
import android.graphics.RectF;

public  class CameraDisplayHelpers {
    public static RectF getVisibleArea(int width, int height, double ratio) {

        if (ratio == -1) {
            return null;
        }

        float xPadding;
        int layerWidth;
        int layerHeight;
        float yPadding;

        if (width <= height) {
            xPadding = ((float) width * 0.05f);
            layerWidth = (int) (width - 2 * xPadding);
            layerHeight = (int) (layerWidth / ratio);
            yPadding = (height - layerHeight) / 2;

        } else {
            yPadding = (int) (height * 0.05);
            layerHeight = (int) (height - 2 * yPadding);
            layerWidth = (int) (layerHeight * ratio);
            xPadding = (width - layerWidth) / 2;
        }

        PointF point1 = new PointF(xPadding, yPadding);
        PointF point3 = new PointF(xPadding + layerWidth, yPadding + layerHeight);

        return new RectF(point1.x, point1.y, point3.x, point3.y);
    }
}
