package com.idenfy.idenfySdk.UI.MainActivity;

import android.Manifest;

import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;


import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.UI.AuthenticationResultView.AuthenticationResultFragment;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country;
import com.idenfy.idenfySdk.UI.InitialAgreementView.InitialAgreementFragmnet;
import com.idenfy.idenfySdk.helpers.DocumentWrapper;
import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfySdk.R;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.ProcessUploadCompletion;
import com.idenfy.idenfySdk.UI.activities.SpashScreenFragment;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.UI.CameraView.CameraNewFragment;

import java.io.File;
import java.util.Objects;



public class CameraPreviewActivity extends AppCompatActivity implements
        AuthenticationResultFragment.OnAuthenticationResultFragmentClosed,
        CameraNewFragment.OnCameraClosedFragment, InitialAgreementFragmnet.OnFragmentInteractionListener,
AuthenticationResultFragment.RetakeStepListener, AuthenticationResultFragment.RetakeStepsListListener,
SpashScreenFragment.OnFragmentInteractionListener, DocumentsRecyclerViewAdapterOld.onItemClickListener {

    public static final String TAG = "CameraPreviewAct";
    private Uri uri = null;
    private CameraViewModel cameraViewModel;
    private DocumentType selectedDocument;
    private RecyclerView recyclerView;
    private TextView toolbarTitle;
    private String authneticationResultResponse="authneticationResultResponse";
    private String idenfyError="idenfyError";


    private void fetchCountriesList()
    {
        cameraViewModel.fetchCountriesList();
    }

    private String AUTH_FRAGMENT = "AuthenticationFragment";
    private int REQUEST_PERMISSIONS_CAMERA = 44444;
    private String SELECT_DOCUMENT_FRAGMENT = "SelectDocumentFragment";
    private String SPLASH_SCREEN_FRAGMENT = "SplashScreenFragment";
    private String BARCODE_DOCUMENT_FRAGMENT = "BarcodeDocumentFragment";
    private String CAMERA_NEW_FRAGMENT = "CameraNewFragment";
    private String INITIAL_AGREEMENT_FRAGMENT = "InitialAgreementFragment";
    private String SIX_DIGITS_BACODE_FRAGMENT = "SixDigitsBarcodeFragment";
    private int delay = 700;
    ConstraintLayout uiMainLayout;
    AppCompatImageView imageView;
    private boolean mReturningWithResult;
    private AlertDialog progressDialog;
    private Toolbar toolbar;
    private ConstraintLayout navbarDefault;
    private ConstraintLayout contentMain;
    public static final String loadingLiveDataCountriesKey = "CountriesList";
    public static final String loadingLiveDataAuthTokenKey = "AuthToken";
    public static final String loadingLiveDataFirstCountryKey = "FirstCountry";


    private Integer idenfyErrorDelayClosing = 1500;
    private Integer idenfySuccessDelayClosing = 1200;




    //Boolean to remove double clicks;
    private boolean isDocumentItemPressed;


    private AppBarLayout appBarLayout;

    private void addAuthenticationResultFragment() {
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        AuthenticationResultFragment authenticationResultFragment = new AuthenticationResultFragment();
        transaction.add(R.id.authenticationResultContainer, authenticationResultFragment, AUTH_FRAGMENT);
        transaction.commit();
    }

    private String activityLifecycle = "activityLifecycle";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        cameraViewModel = ViewModelProviders.of(this).get(CameraViewModel.class);
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        restoreAppAfterDeath(savedInstanceState);
        initialRequests();
        observeCountriesList();
        observeProccessUploadCompletion();
        observeUploadsFinished();
        observeSDKResponse();
        observeCheckTokenResponse();
        cameraViewModel.setIsBackFotoapparatCamera(true);
        cameraViewModel.getIsBackFotoapparatCamera().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    if (!response) {
                        delay = 700;
                    }

            }
        });
        setContentView(R.layout.activity_main_new);
        initializeSpashScreen();
        initializeUI();
        observeCameraFragmentAndUI();
        observeAuthenticationResultFragment();
        observeSdkLoading();

        cameraViewModel.mainActivityViewVisibility.observe(this, response->
        {

            if(response!=null && response) {
                appBarLayout.setVisibility(View.VISIBLE);
                uiMainLayout.setVisibility(View.VISIBLE);
                contentMain.setVisibility(View.VISIBLE);
                reInitViewModelLogic();
            }
        });


    }

    private void initializeSpashScreen() {
    }


    @Override
    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        cameraViewModel.addInitialAgreementFragmentLiveData().observe(this, canAdd ->
        {
            if (canAdd != null) {
                if (canAdd) {
                    toolbarTitle.setText(getResources().getString(R.string.start_identity_verification));
                    addInitialAgrrementFragment();

                } else {

                    removeInitialAgrrementFragment();
                    toolbarTitle.setText("Idenfy");
                    getCameraPermission();
                }
            }
        });

    }
    @Override
    protected void onStart() {
        super.onStart();
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        // cameraViewModel.setMainActivityViewVisibility(true);
        if (fragment == null) {
            cameraViewModel.setMainActivityViewVisibility(true);

        }

        Log.d("idenfy2.0", "onStartCameraActivity");

    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPostResume() {
        super.onPostResume();
    }

    @Override
    protected void onStop() {

        super.onStop();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }


    @Override
    public void onSaveInstanceState(Bundle outState) {
        if(cameraViewModel.getIdenfyError().getValue()!=null)
        {
            IdenfyError idenfyError = cameraViewModel.getIdenfyError().getValue();
            outState.putParcelable(this.idenfyError, idenfyError);
        }
        if(cameraViewModel.authneticationResultResponse.getValue()!=null)
        {
            if(cameraViewModel.authneticationResultResponse.getValue().data!=null)
            {
                if(cameraViewModel.authneticationResultResponse.getValue().data.
                        getIdentificationStatus()!=null && cameraViewModel.authneticationResultResponse.getValue().data.
                        getIdentificationStatus().equalsIgnoreCase("APPROVED"))
                {
                    outState.putParcelable(authneticationResultResponse, cameraViewModel.authneticationResultResponse.getValue().data);
                }
            }
        }
        outState.putParcelable("settings", IdenfyController.getInstance().getSettings());
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        if (item.getItemId() == android.R.id.home) {
            onBackPressed(); // close this activity and return to preview activity (if there is any)
        }

        return super.onOptionsItemSelected(item);
    }
    private void initializeUI()
    {
        IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
        contentMain = findViewById(R.id.content_main);
        navbarDefault = findViewById(R.id.navbar_default);
        appBarLayout = findViewById(R.id.app_bar);
        toolbarTitle = findViewById(R.id.toolbar_title);
        toolbarTitle.setText("Idenfy");
        toolbarTitle.setTypeface((idenfySettings.getIdenfyFont()));
        addSplashScreenFragment();
        toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        Objects.requireNonNull(getSupportActionBar()).setElevation(4);
        getSupportActionBar().setDisplayShowTitleEnabled(false);
        getSupportActionBar().setTitle("");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_NOSENSOR);
        setTheme(R.style.IdenfyTheme);
        uiMainLayout = findViewById(R.id.ui_main_layout);
        initRecyclerView();
        imageView = findViewById(R.id.imageViewLogo);

    }
    private void addSplashScreenFragment()
    {
        SpashScreenFragment cameraNewFragment = new SpashScreenFragment();
        getSupportFragmentManager().
                beginTransaction().add(R.id.splash_screen, cameraNewFragment, SPLASH_SCREEN_FRAGMENT)
                .commit();
    }
    private void observeCountriesList()

    {
        cameraViewModel.getCountryFromIPLiveDataAndDecideToShowFragment().observe(this,  response->
        {
            cameraViewModel.getCountriesListMutableLiveData().observe(this, countriesList->
            {
                if(response!=null)
                {
                    Country firstCountry = null;
                    int sameIndex = 0;
                    if(response.status==Status.SUCCESS)
                    {
                        if (countriesList != null && countriesList.status == Status.SUCCESS) {

                            for (int i = 0; i < Objects.requireNonNull(countriesList.data).size(); i++) {
                                if (countriesList.data.get(i).getCountryISO().
                                        equalsIgnoreCase(response.data)) {
                                    firstCountry= countriesList.data. get(i);
                                    sameIndex = i;
                                }
                                if(firstCountry!=null) {
                                    countriesList.data.add(0, firstCountry);
                                    countriesList.data.remove(sameIndex + 1);
                                    break;
                                }

                            }
                            cameraViewModel.setCountriesList(countriesList);
                        }
                    }
                    if(response.status== Status.ERROR)
                    {
                        if(countriesList!=null)
                            cameraViewModel.setCountriesList(countriesList);
                    }

                }
            });
        });
    }


    private void restoreAppAfterDeath(Bundle savedInstanceState)
    {

        IdenfySettings idenfySettingsRestored = null;
        if (savedInstanceState != null) {
            if(savedInstanceState.getParcelable(idenfyError)!=null)
            {
                IdenfyError idenfyError = savedInstanceState.getParcelable(this.idenfyError);
                if (idenfyError != null) {
                    IdenfyController.idenfyError =idenfyError.getIdenfyErrorResponse();
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                }
            }
            if(savedInstanceState.getParcelable(authneticationResultResponse)!=null)
            {
                IdenfyController.authenticationResultResponse =savedInstanceState.getParcelable(authneticationResultResponse);
                deleteCache(CameraPreviewActivity.this);
                finish();
            }
            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(false);
            if (savedInstanceState.getParcelable("settings") != null) {
                idenfySettingsRestored = savedInstanceState.getParcelable("settings");
                if (idenfySettingsRestored != null) {
                    Log.d(activityLifecycle, idenfySettingsRestored.toString());
                }
                IdenfyController.getInstance().setSettings(Objects.requireNonNull(savedInstanceState.getParcelable("settings")));
            }

        }
    }
    private void observeProccessUploadCompletion()
    {
        cameraViewModel.getProcessUploadCompletion().observe(this, uploadCompleted ->
        {
            if (uploadCompleted != null) {
                if(uploadCompleted.status== Status.SUCCESS)
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            cameraViewModel.startCheckingForAuthenticationesults();
                        }

                    }, cameraViewModel.CHECKING_RESULTS_DELAY);
            }
        });
    }
    private void observeUploadsFinished()
    {
        cameraViewModel.getUploadsFinished().observe(this, response ->
        {
            if (response != null) {
                if (response.containsKey(DocumentType.ID_CARD_FRONT) && response.get(DocumentType.ID_CARD_FRONT)
                        && response.containsKey(DocumentType.ID_CARD_BACK)
                        &&
                        response.get(DocumentType.ID_CARD_BACK)
                        && response.containsKey(DocumentType.FACE_PHOTO) &&
                        response.get(DocumentType.FACE_PHOTO)) {

                    cameraViewModel.startProcessing();
                    if(IdenfyController.getInstance().getSettings().getHandleResultsChecking()!=null
                            && IdenfyController.getInstance().getSettings().getHandleResultsChecking()) {
                        IdenfyController.processUploadCompletion = new ProcessUploadCompletion();
                        IdenfyController.processUploadCompletion.setBackIdUploaded(true);
                        IdenfyController.processUploadCompletion.setFaceImageUploaded(true);
                        IdenfyController.processUploadCompletion.setFrontIdUploaded(true);
                    }
                }
                if(response.containsKey(DocumentType.PASSPORT) && response.get(DocumentType.PASSPORT)
                        && response.containsKey(DocumentType.FACE_PHOTO) &&
                        response.get(DocumentType.FACE_PHOTO))
                {
                    if(IdenfyController.getInstance().getSettings().getHandleResultsChecking()) {
                        IdenfyController.processUploadCompletion = new ProcessUploadCompletion();
                        IdenfyController.processUploadCompletion.setPassportUploaded(true);
                        IdenfyController.processUploadCompletion.setFaceImageUploaded(true);
                    }
                    cameraViewModel.startProcessing();
                }
            }
        });
    }
    private void initialRequests()
    {
        cameraViewModel.checkAuthTokenRequest(IdenfyController.getInstance().getSettings().getToken(),
                false, null);
        fetchCountriesList();
        cameraViewModel.fetchCountryByIp();
    }

    private void observeCameraFragmentAndUI()
    {
        cameraViewModel.getAddCameraFragment().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null && aBoolean) {

                    addCameraFragment();
                }
            }
        });
    }
    private void observeAuthenticationResultFragment()
    {
        cameraViewModel.getAuthenticationResultFragmentLiveData().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (response) {
                        CameraPreviewActivity.this.addAuthenticationResultFragment();
                    }
                    else
                    {
                        removeAuthenticationResultFragment();
                    }
                }
            }
        });
    }
    private void observeSdkLoading()
    {
        cameraViewModel.mainLoadingMediatorLiveDara.observe(this, response->
        {
            if (response != null && response.status == Status.SUCCESS) {

                if ((response.data != null) && response.data.containsKey(
                        loadingLiveDataCountriesKey) &&
                        response.data.get(loadingLiveDataCountriesKey)
                        && response.data.containsKey(loadingLiveDataAuthTokenKey)
                        && response.data.get(loadingLiveDataAuthTokenKey)
                        && response.data.containsKey(loadingLiveDataFirstCountryKey) &&
                        response.data.get(loadingLiveDataFirstCountryKey)) {
                   if (IdenfyController.getInstance().getSettings().getSelectedCountry()==null)
                       cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true);
                   else
                       cameraViewModel.isRecyclerViewEnabled=true;
                       removeSplashScreenFragment();
                }
                else if(response.data!=null &&
                        response.data.containsKey(loadingLiveDataCountriesKey)
                        &&response.data.get(loadingLiveDataCountriesKey)
                        &&response.data.containsKey(loadingLiveDataAuthTokenKey) &&
                        response.data.get(loadingLiveDataAuthTokenKey))
                {
                   if(IdenfyController.getInstance().getSettings().getSelectedCountry()==null)
                       cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true);
                   else
                       cameraViewModel.isRecyclerViewEnabled=true;
                    removeSplashScreenFragment();
                }


            }
        });
    }

    private void observeSDKResponse() {
        cameraViewModel.getIdenfyError().observe(this, error ->
        {
            if (error != null) {
                if(error.getTerminateWithoutWaitingResult()) {
                    cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true);
                }
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                            IdenfyController.idenfyError = error.getIdenfyErrorResponse();
                            deleteCache(CameraPreviewActivity.this);
                            finish();
                    }

                }, idenfyErrorDelayClosing);
            }
        });
        cameraViewModel.getProcessUploadCompletion().observe(this, processUploadCompletionResource ->
        {
            if (processUploadCompletionResource != null) {
                if(IdenfyController.getInstance().getSettings().getHandleResultsChecking()!=null
                        &&IdenfyController.getInstance().getSettings().getHandleResultsChecking() ) {
                    IdenfyController.processUploadCompletion.setSuccess(true);
                }
            }
        });
        cameraViewModel.authneticationResultResponse.observe(this, response->
        {
            if(response!=null)
            if(response.data!=null){
                if(response.data.getIdentificationStatus()!=null && response.data.getIdentificationStatus().equalsIgnoreCase("APPROVED"))
                {
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                    IdenfyController.authenticationResultResponse = response.data;
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                        }

                    }, idenfySuccessDelayClosing);
                }
            }

        });
    }
    private void observeCheckTokenResponse() {
        cameraViewModel.getCheckAuthTokenLiveData().observe(this, response ->
        {
            if (response != null) {

                if (response.status == Status.SUCCESS) {
                    if (response.data != null) {
                        if (response.data.equals("1")) {
                            cameraViewModel.setAddSixDigitsFragmentMutableLiveData(false);
                        } else if (response.data.equals("0")) {
                            cameraViewModel.setAddSixDigitsFragmentMutableLiveData(true);
                            snackBarTokenExpired();
                        } else if (response.data.equals("-1")) {
                            cameraViewModel.setAddSixDigitsFragmentMutableLiveData(true);
                            snackBarTokenExpired();
                        }
                    }

                } else if (response.status == Status.ERROR) {
                    dismissProgressDialog();
                    if (response.message != null) {
                        {
                            snackBarTokenExpired();
                        }

                    }
                }


            }
        });
    }

    private void showsnackBar(String message) {
        Snackbar mySnackbar = Snackbar.make(findViewById(R.id.newMain),
                message, Snackbar.LENGTH_SHORT);
        mySnackbar.show();
    }

    private void snackBarTokenExpired() {

    }

    private void removeInitialAgrrementFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT);
        if (fragment != null) {

            cameraViewModel.isRecyclerViewEnabled= true;
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }

    }

    private void removeSplashScreenFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(SPLASH_SCREEN_FRAGMENT);
        if(fragment!=null)
        {
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }
    }


    private void dismissProgressDialog() {
        if (progressDialog != null
                )
            progressDialog.dismiss();
    }



    private void addInitialAgrrementFragment() {
        Fragment initialAgreementFragment = getSupportFragmentManager().findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT);
        if (initialAgreementFragment == null) {
            InitialAgreementFragmnet cameraNewFragment = new InitialAgreementFragmnet();
            getSupportFragmentManager().
                    beginTransaction().add(R.id.setupContainer, cameraNewFragment, INITIAL_AGREEMENT_FRAGMENT)
                    .commit();
        }
    }





    private void reInitViewModelLogic() {

            Log.d("idenfy2.0", "reinitViewModelLogic");
            DocumentWrapper documentWrapper = new DocumentWrapper(
                    DocumentType.ID_CARD_FRONT,
                    true, false,
                    false,
                    true,
                    false,
                    false,
                    false,
                    true,
                    false
                    , false,
                    true
                    , true
            );
            cameraViewModel.setDocumentTypeResponseMutableLiveData.postValue(Resource.loading(null));
            cameraViewModel.clearUploadsFinished();
            cameraViewModel.setDocumentInfo(documentWrapper);
            cameraViewModel.clearRetakedSteps();
    }
    private void makeMainLayoutVisible()
    {
        appBarLayout.setVisibility(View.VISIBLE);
        contentMain.setVisibility(View.VISIBLE);
        uiMainLayout.setVisibility(View.VISIBLE);
    }



    AlertDialog restartAuthenticationDialog;
    private void showRestartAuhenticationDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);

        builder.setTitle(R.string.start_over_alert_title);
        builder.setMessage(R.string.start_over_alert_message);
        builder.setPositiveButton(R.string.no_alert_button, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
            }
        });
        builder.setNegativeButton(getResources().getString(R.string.yes_alert_button),
                new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                cameraViewModel.authneticationResultResponse.setValue(Resource.loading(null));
             restartAuthenticationLogic();
                dialog.dismiss();
            }
        });
            restartAuthenticationDialog = builder.create();
            restartAuthenticationDialog.show();
            restartAuthenticationDialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(getResources().getColor(R.color.idenfyColorPrimary));
            restartAuthenticationDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(getResources().getColor(R.color.idenfyColorAccent));
        }

   // }
    private void restartAuthenticationLogic()
    {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment != null) {
            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(false);

        }
        reInitViewModelLogic();
        makeMainLayoutVisible();
    }
    AlertDialog closeAppAlertDialog;
    private void showCloseAppAlertDialog() {


        AlertDialog.Builder builder = new AlertDialog.Builder(this);

        builder.setTitle(R.string.abort_identification_alert_title);
        builder.setMessage(R.string.abort_identification_alert_message);

        builder.setPositiveButton(R.string.no_alert_button, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
            }
        });

        builder.setNegativeButton(R.string.yes_alert_button, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                IdenfyController.exitCode = new ExitCode(1);
                deleteCache(CameraPreviewActivity.this);
                finish();
                dialog.dismiss();
            }
        });
        closeAppAlertDialog = builder.create();
        closeAppAlertDialog.show();
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(getResources().getColor(R.color.idenfyColorPrimary));
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(getResources().getColor(R.color.idenfyColorAccent));
    }




    public boolean getCameraPermission() {
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
            requestCameraPermission();
            delay = 700;
            return false;
        } else {
           // cameraViewModel.setAddCameraFragment(true);
            return true;
        }
    }

    private void requestCameraPermission() {
        Log.i(TAG, "CAMERA permission has NOT been granted. Requesting permission.");

        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                Manifest.permission.CAMERA)) {
            Log.i(TAG,
                    "Displaying camera permission rationale to provide additional context.");

            ActivityCompat.requestPermissions(CameraPreviewActivity.this,
                    new String[]{Manifest.permission.CAMERA},
                    REQUEST_PERMISSIONS_CAMERA
            );
        } else {

            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.CAMERA},
                    REQUEST_PERMISSIONS_CAMERA
            );
        }
    }


    public static void deleteCache(Context context) {
        try {
            File dir = context.getCacheDir();
            deleteDir(dir);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initRecyclerView() {
         recyclerView = findViewById(R.id.documentsRecyclerView);
        recyclerView.addItemDecoration(new DividerItemDecoration(this,
                DividerItemDecoration.VERTICAL));

        LinearLayoutManager manager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        recyclerView.setLayoutManager(manager);

        DocumentsRecyclerViewAdapterOld adapter = new DocumentsRecyclerViewAdapterOld(
                DocumentType.getValues(), this);

        recyclerView.setAdapter(adapter);
    }

    public static boolean deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; i++) {
                boolean success = deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
            }
            return dir.delete();
        } else if (dir != null && dir.isFile()) {
            return dir.delete();
        } else {
            return false;
        }
    }


    private boolean addCameraFragment() {

        cameraViewModel.setMainActivityViewVisibility(false);
        boolean isFragmentNew = false;

        Fragment fragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);

        if (fragment == null) {
            isFragmentNew = true;
            CameraNewFragment cameraNewFragment = new CameraNewFragment();
            getSupportFragmentManager().
                    beginTransaction().add(R.id.mainContainer, cameraNewFragment, CAMERA_NEW_FRAGMENT)
                    .commit();
        }
        return isFragmentNew;

    }


    public void selectDocument( DocumentType document) {

        this.selectedDocument = document;
        if (getCameraPermission()) {

            observeIfCanSetupCameraFragment(document);
            cameraViewModel.shouldDeleteCustomViews = true;
            cameraViewModel.setDocumentType(document);

        } else {
            isDocumentItemPressed = false;
            showsnackBar(getResources().getString(R.string.provide_permissions_manually));
        }
    }

    private void observeIfCanSetupCameraFragment(DocumentType document) {
        cameraViewModel.getSetDocumentTypeResponseMutableLiveData().observe(this, responseBodyResource -> {
            if (responseBodyResource != null) {
                if (responseBodyResource.status == Status.LOADING) {

                }
                else if (responseBodyResource.status == Status.SUCCESS) {
                    cameraViewModel.setCurrentDocument(this.selectedDocument);
                    cameraViewModel.setDocumentInfo(setupInitialDocument(this.selectedDocument));
                    cameraViewModel.setIsBackFotoapparatCamera(true);
                    setupViewToGetPhoto(this.selectedDocument);

                }
                else if (responseBodyResource.status == Status.ERROR) {
                }

            }
        });

    }

    private DocumentWrapper setupInitialDocument(DocumentType document) {
        return new DocumentWrapper(document,
                true, false,
                false,
                true,
                false,
                false,
                false,
                true,
                false
                , false,
                true
                , true
        );
    }

    private void setupViewToGetPhoto(final DocumentType document) {

        new Handler().postDelayed(new Runnable() {


            @Override
            public void run() {
                appBarLayout.setVisibility(View.INVISIBLE);
                uiMainLayout.setVisibility(View.GONE);
                contentMain.setVisibility(View.GONE);
                cameraViewModel.canSetCameraView(true);
                cameraViewModel.setAddCameraFragment(true);
                isDocumentItemPressed = false;

            }
        }, 500);


    }

    public void removeAuthenticationResultFragment()
    {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment != null) {
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }
    }



    @Override
    public void onBackPressed() {

        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment == null) {
            if (uiMainLayout.getVisibility() != View.VISIBLE) {
                showRestartAuhenticationDialog();
            }
            if(uiMainLayout.getVisibility()==View.VISIBLE)
            {
                showCloseAppAlertDialog();
            }
        }
        else
        {
            if(cameraViewModel.authneticationResultResponse.getValue()!=null &&
                    cameraViewModel.authneticationResultResponse.getValue().data!=null&&
                    cameraViewModel.authneticationResultResponse.getValue().status!=Status.LOADING&&
                    cameraViewModel.authneticationResultResponse.getValue().data.getProcessingStatus()!=null&&
                    cameraViewModel.authneticationResultResponse.getValue().data.getProcessingStatus().
                            equalsIgnoreCase("FINISHED"))
            {
                showRestartAuhenticationDialog();
            }

        }



    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_PERMISSIONS_CAMERA) {
            if (permissions.length > 0) {
                if (permissions[0].equals(Manifest.permission.CAMERA)
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    mReturningWithResult = true;
                    if(this.selectedDocument!=null)
                    {
                        observeIfCanSetupCameraFragment(this.selectedDocument);
                        cameraViewModel.setDocumentType(this.selectedDocument);
                    }

                } else {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                                Manifest.permission.CAMERA)) {
                            ActivityCompat.requestPermissions(CameraPreviewActivity.this,
                                    new String[]{Manifest.permission.CAMERA},
                                    REQUEST_PERMISSIONS_CAMERA);
                            return;
                        }
                    }
                }
            }
        }
    }
    @Override
    public void onAuthenticationResultFragmentClosed(boolean closed) {
        removeAuthenticationResultFragment();

    }
    @Override
    public void onCameraNewFragmentClosed(boolean wasSucess) {
        onBackPressed();
    }

    @Override
    public void onFragmentInteraction(Uri uri) {

    }

    @Override
    public void onRetakeStepSelected(DocumentType document) {
        if(document==DocumentType.FACE_PHOTO)
        {
            cameraViewModel.setIsBackFotoapparatCamera(false);
        }
        else
        {
            cameraViewModel.setIsBackFotoapparatCamera(true);
        }
        cameraViewModel.processUploadCompletion.postValue(Resource.loading(null));
        cameraViewModel.setDocumentTypeMutableLiveData(document);
        cameraViewModel.setDocumentInfo(setupInitialDocument(document));
        removeAuthenticationResultFragment();



    }

    @Override
    public void onRetakeStepsList(Boolean value) {
        if(cameraViewModel.retakeDocumentsList.getValue()!=null && cameraViewModel.retakeDocumentsList.getValue().size()>=1) {
            DocumentType document = cameraViewModel.retakeDocumentsList.getValue().get(0);
            if (document == DocumentType.FACE_PHOTO) {
                cameraViewModel.setIsBackFotoapparatCamera(false);
            } else {
                cameraViewModel.setIsBackFotoapparatCamera(true);
            }
            cameraViewModel.processUploadCompletion.postValue(Resource.loading(null));
            cameraViewModel.setDocumentTypeMutableLiveData(document);
            cameraViewModel.setDocumentInfo(setupInitialDocument(document));
            removeAuthenticationResultFragment();
        }
    }

    @Override
    public void onClick(DocumentType type) {
        {
            if (cameraViewModel.isRecyclerViewEnabled) {
                if (!isDocumentItemPressed) {
                    isDocumentItemPressed = true;
                    CameraPreviewActivity.this.selectDocument(type);
                }
                else
                {
                    Log.d("notresponding", "not responding");
                }
            }
        }

        }
    }

