package com.idenfy.idenfySdk.UI.CustomViews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;

import com.idenfySdk.R;
import com.idenfy.idenfySdk.UI.UIHelpers.DpToPixelConverter;

public class Rectangle extends View {
    Paint strokeRectangle = new Paint();
    int left;
    int top;
    int right;
    int bottom;
    Rect rectangle;
    RectF transParentBackground;
    boolean transparentBackgroundVisibility=true;
    private Paint mBackgroundPaint;
    private int transparentBackgroundColor = getResources().getColor(R.color.idenfyTransparentCameraOverlay);
    private int transparentBackgroundColorBlack = getResources().getColor(R.color.idenfyPhotoResultBackgroundColor);
    private int paddingDefault =  DpToPixelConverter.dpToPx(5);

    public Rectangle(Context context, int left, int top, int right, int bottom) {
        super(context);
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        if(this.left>this.right)
        {
            int c = this.left;
            int k = this.right;
            this.right = c;
            this.left =k;
        }
        if(this.bottom>this.right)
        {

        }
        setWillNotDraw(false);
        setLayerType(LAYER_TYPE_HARDWARE, null);
        mBackgroundPaint = new Paint();
        mBackgroundPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        rectangle = new Rect(this.left
                - paddingDefault
                , this.top  - paddingDefault,
                this.right + paddingDefault,
                this.bottom + paddingDefault);
        transParentBackground = new RectF(
                this.left,
                this.top,
                this.right,
                this.bottom
        );
    }



    @Override
    public void onDraw(Canvas canvas) {
        if(transparentBackgroundVisibility) {
            canvas.drawColor(transparentBackgroundColor);
            canvas.drawRect(transParentBackground, mBackgroundPaint);
        }
        else
        {
            canvas.drawColor(transparentBackgroundColorBlack);
            canvas.drawRect(transParentBackground, mBackgroundPaint);
        }
        strokeRectangle.setStyle(Paint.Style.STROKE);
        strokeRectangle.setColor(getResources().getColor(R.color.idenfyDocumentBorderColor));
        strokeRectangle.setStrokeWidth(DpToPixelConverter.dpToPx(2));
        canvas.drawRect(rectangle, strokeRectangle);
    }


    public void changeTransparentBackgroundVisibility(Boolean isVisible) {
        this.transparentBackgroundVisibility = isVisible;
    }
}