package com.idenfy.idenfySdk.Networking;

import com.idenfySdk.BuildConfig;

import java.util.concurrent.TimeUnit;

import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public interface RetrofitFactoryUploadingFiles {
        static APIService create() {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            String hostname = "ivs.idenfy.com";
            CertificatePinner certificatePinner = new CertificatePinner.Builder()
                    .add(hostname, BuildConfig.ROOT_PIN)
                    .add(hostname, BuildConfig.INTERMEDIATE_PIN)
                    .add(hostname, BuildConfig.LEAF_PIN)
                    .build();
            OkHttpClient client = new OkHttpClient.Builder()
                    .addInterceptor(interceptor)
                    .certificatePinner(certificatePinner)
                    .connectTimeout(150, TimeUnit.SECONDS)
                    .writeTimeout(150, TimeUnit.SECONDS)
                    .readTimeout(150, TimeUnit.SECONDS)
                    .build();
            Retrofit retrofit = new Retrofit.Builder()
                    .baseUrl("https://ivs.idenfy.com/")
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(client)
                    .build();
            return retrofit.create(APIService.class);
        }
}