package com.idenfy.idenfySdk.Networking;

import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest;
import com.idenfy.idenfySdk.Networking.Models.CountryCode;
import com.idenfy.idenfySdk.Networking.Models.CountrySetRequest;
import com.idenfy.idenfySdk.Networking.Models.StreamPost;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;

import java.util.Map;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;

public interface APIService {

    @Headers("Content-Type: application/json")
    @POST("identification/start-process")
    Call<ResponseBody> startProcess(
            @Body AuthTokenRequest rawJson
    );
    @Headers("Content-Type: application/json")
    @POST("token/start-session")
    Call<ResponseBody> startSession(
            @Body AuthTokenRequest rawJson
    );
    @Headers("Content-Type: application/json")
    @POST("storage/store/stream")
    Call<ResponseBody> streamPhotoNew(
            @Body StreamPost moment
    );
    @Headers("Content-Type: application/json")
    @POST("identification/get/result")
    Call<AuthenticationResultResponse> checkAuthenticationStatus(
            @Body AuthTokenRequest rawJson
    );
    @Headers("Content-Type: application/json")
    @POST("token/check")
    Call<ResponseBody> checkAuthToken(
            @Body AuthTokenRequest rawJson
    );
    @Headers("Content-Type: application/json")
    @POST("identification/set/country")
    Call<ResponseBody> setIssuingCountry(
            @Body CountrySetRequest rawJson
    );
    @GET("other/geoip-country")
    Call<CountryCode> getCountryByIPAd(
    );

    @Headers("Content-Type: application/json")
    @POST("document/set")
    Call<ResponseBody> setDocumentType(
            @Body Map<String, String> rawJson
    );


}
