package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.helpers.enums.AuthentificationResult;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.SdkResponseModels.ProcessUploadCompletion;

/**
 * Created by Demid Ilkevič on 10/20/2017.
 */

public class IdenfyController {



    private IdenfySettings settings;
    public static ExitCode exitCode;
    public static IdenfyErrorResponse idenfyError;
    public static  ProcessUploadCompletion processUploadCompletion;
    public static AuthenticationResultResponse authenticationResultResponse;
    private static final int exitCodeTerminated = -1;


    public static void handleActivityResult(int resultCode, Intent data, AuthenticationListenerNew authenticationListenerNew) {
        if(idenfyError!=null)
        authenticationListenerNew.onError(idenfyError);
        if(processUploadCompletion!=null)
        authenticationListenerNew.onProcessCompleted(processUploadCompletion);
        if(exitCode==null && idenfyError==null && authenticationResultResponse==null) {
            //applicationTerminatedExitCode
            authenticationListenerNew.userExcited(new ExitCode(exitCodeTerminated));
        }
        else if(idenfyError==null && authenticationResultResponse==null) {
            authenticationListenerNew.userExcited(exitCode);
        }
        if(authenticationResultResponse!=null)
        {
            authenticationListenerNew.onAuthenticationResult(authenticationResultResponse);
        }
    }
//    public void setResults(ExitCode exitCode, IdenfyError idenfyError, ProcessUploadCompletion processUploadCompletion)
//    {
//        this.exitCode = exitCode;
//        this.idenfyError = idenfyError;
//        this.processUploadCompletion = processUploadCompletion;
//    }

    public interface AuthenticationListener {
        void onAutentification(AuthentificationResult result);
    }
    public interface AuthenticationListenerNew {
        default void onProcessCompleted(ProcessUploadCompletion result) {
            return;
        }

       default void userExcited(ExitCode result)
       {

       }
        default  void onError(IdenfyErrorResponse result)
        {

        };
        void onAuthenticationResult(AuthenticationResultResponse authenticationResultResponse);

    }

    private IdenfyController() {

    }

//    public static void setupFonts(Context context, TextView... texts) {
//        Typeface tf = Typeface.createFromAsset(context.getAssets(),
//                "fonts/MyriadPro-Regular.otf");
//
//        for (TextView txt : texts) {
//            if (txt == null) {
//                continue;
//            }
//            txt.setTypeface(tf);
//        }
//    }

    public AuthenticationListener mListener;

    public static IdenfyController getInstance() {

        if (instance == null) {
            instance = new IdenfyController();
        }

        return instance;
    }


    public void initialize(@NonNull IdenfySettings settings1, @Nullable AuthenticationListener listener) {
        this.settings = settings1;
        Log.e("BBB", "settyings: " + settings1);
        mListener = listener;
    }

    public void startAutentification(@NonNull Context context) {
        if (settings == null) {
            throw new IllegalStateException("call IdenfyContoller.getInstance().initialize(...) first");
        } else {
            Intent intent = new Intent(context, CameraPreviewActivity.class);
            context.startActivity(intent);
        }

    }
    public void startAuthentication(Activity context, int requestCode, IdenfySettings idenfySettings)
    {
        this.settings = idenfySettings;
        if (settings == null) {
            throw new IllegalStateException("call IdenfyContoller.getInstance().initialize(...) first");
        } else {
            Intent intent = new Intent(context, CameraPreviewActivity.class);
            Bundle bundle = new Bundle();
            this.settings.setHandleResultsChecking(false);
            bundle.putBoolean("handleCallback", false);
            context.startActivityForResult(intent, requestCode, bundle);
        }
    }

    public void setSettings(@NonNull IdenfySettings settings) {
        this.settings = settings;
    }

    public
    IdenfySettings getSettings() {
        return this.settings;
    }

    private static IdenfyController instance;

}
