/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.starteam.StarTeamChangeSet;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamFilePoint;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.plugins.starteam.StarTeamViewSelector;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTeamPollingActor
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = -5678102033953507247L;
    private String hostname;
    private int port;
    private String user;
    private String passwd;
    private String projectname;
    private String viewname;
    private String foldername;
    private final TaskListener listener;
    private final StarTeamViewSelector config;
    private Collection<StarTeamFilePoint> historicFilePoints;

    public StarTeamPollingActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, StarTeamViewSelector config, TaskListener listener, Collection<StarTeamFilePoint> historicFilePoints) {
        this.hostname = hostname;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.listener = listener;
        this.config = config;
        this.historicFilePoints = historicFilePoints;
    }

    public Boolean invoke(File f, VirtualChannel channel) throws IOException {
        StarTeamConnection connection = new StarTeamConnection(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, this.config);
        try {
            connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            connection.close();
            return false;
        }
        StarTeamChangeSet changeSet = null;
        try {
            changeSet = connection.computeChangeSet(connection.getRootFolder(), f, this.historicFilePoints, this.listener.getLogger());
        }
        catch (StarTeamSCMException e) {
            e.printStackTrace(this.listener.getLogger());
        }
        connection.close();
        if (changeSet != null && changeSet.hasChanges()) {
            return true;
        }
        return false;
    }
}

