/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.Util;
import hudson.plugins.starteam.StarTeamChangeLogEntry;
import hudson.plugins.starteam.StarTeamChangeSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StarTeamChangeLogBuilder {
    public static boolean writeChangeLog(OutputStream outputStream, StarTeamChangeSet changeSet) throws IOException {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
        dateFormat.setCalendar(cal);
        dateFormat.setLenient(false);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        PrintWriter printwriter = new PrintWriter(writer);
        printwriter.println("<?xml version='1.0' encoding='UTF-8'?>");
        printwriter.println("<changelog>");
        for (StarTeamChangeLogEntry change : changeSet.getChanges()) {
            StarTeamChangeLogBuilder.writeEntry((SimpleDateFormat)dateFormat, (PrintWriter)printwriter, (StarTeamChangeLogEntry)change);
        }
        printwriter.println("</changelog>");
        printwriter.close();
        return true;
    }

    private static void writeEntry(SimpleDateFormat dateFormat, PrintWriter printwriter, StarTeamChangeLogEntry change) {
        printwriter.println("\t<entry>");
        printwriter.println("\t\t<fileName>" + Util.xmlEscape((String)change.getFileName()) + "</fileName>");
        printwriter.println("\t\t<revisionNumber>" + change.getRevisionNumber() + "</revisionNumber>");
        Date aDate = change.getDate();
        printwriter.println("\t\t<date>" + Util.xmlEscape((String)dateFormat.format(aDate)) + "</date>");
        printwriter.println("\t\t<message>" + Util.xmlEscape((String)change.getMsg()) + "</message>");
        printwriter.println("\t\t<user>" + Util.xmlEscape((String)change.getUsername()) + "</user>");
        printwriter.println("\t\t<changeType>" + Util.xmlEscape((String)change.getChangeType()) + "</changeType>");
        printwriter.println("\t</entry>");
    }
}

