/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.BuildListener;
import hudson.plugins.cmake.EnvVarReplacer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class CmakeLauncher {
    private final Launcher launcher;
    private final EnvVars envs;
    private final FilePath workSpace;
    private final BuildListener listener;
    private final String buildDir;

    public CmakeLauncher(Launcher launcher, EnvVars envs, FilePath workSpace, BuildListener listener, String buildDir) {
        this.launcher = launcher;
        this.envs = envs;
        this.workSpace = workSpace;
        this.listener = listener;
        this.buildDir = buildDir;
    }

    public boolean launchCmake(String cmakeCall) throws IOException, InterruptedException {
        int result = this.launcher.launch(cmakeCall, (Map)this.envs, (OutputStream)this.listener.getLogger(), new FilePath(this.workSpace, this.buildDir)).join();
        return result == 0;
    }

    public boolean launchMake(String makeCommand) throws IOException, InterruptedException {
        if (makeCommand.trim().isEmpty()) {
            return true;
        }
        int result = this.launcher.launch(makeCommand = EnvVarReplacer.replace((String)makeCommand, (Map)this.envs), (Map)this.envs, (OutputStream)this.listener.getLogger(), new FilePath(this.workSpace, this.buildDir)).join();
        return result == 0;
    }

    public boolean launchInstall(String installDir, String installCommand) throws IOException, InterruptedException {
        boolean doInstall;
        boolean bl = doInstall = !installDir.isEmpty() && !installCommand.trim().isEmpty();
        if (!doInstall) {
            return true;
        }
        int result = this.launcher.launch(installCommand = EnvVarReplacer.replace((String)installCommand, (Map)this.envs), (Map)this.envs, (OutputStream)this.listener.getLogger(), new FilePath(this.workSpace, this.buildDir)).join();
        return result == 0;
    }
}

