/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.FilePath;
import hudson.plugins.cmake.CmakeBuilderImpl;
import hudson.plugins.cmake.EnvVarReplacer;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmakeBuilderImpl {
    private static final String DCMAKE_BUILD_TYPE = "-DCMAKE_BUILD_TYPE=";
    private static final String DCMAKE_INSTALL_PREFIX = "-DCMAKE_INSTALL_PREFIX=";
    private static final String BLANK = " ";

    String preparePath(FilePath workSpace, Map<String, String> envVars, String path, PreparePathOptions ppOption) throws IOException {
        if ((path = path.trim()).isEmpty()) {
            return path;
        }
        path = EnvVarReplacer.replace((String)path, envVars);
        FilePath file = workSpace.child(path);
        ppOption.process(file);
        return file.getRemote();
    }

    String buildCMakeCall(String cmakeBin, String generator, String preloadScript, String sourceDir, String installDir, String buildType, String cmakeArgs) {
        StringBuilder builder = new StringBuilder().append(cmakeBin).append(BLANK).append(this.createPreloadScriptArg(preloadScript)).append(BLANK).append("-G \"").append(generator).append("\"").append(BLANK);
        if (!installDir.isEmpty()) {
            builder.append(DCMAKE_INSTALL_PREFIX).append(installDir).append(BLANK);
        }
        builder.append(DCMAKE_BUILD_TYPE).append(buildType).append(BLANK).append(cmakeArgs).append(BLANK).append("\"").append(sourceDir).append("\"").append(BLANK);
        return builder.toString();
    }

    private String createPreloadScriptArg(String preloadScript) {
        if (preloadScript == null || preloadScript.trim().isEmpty()) {
            return "";
        }
        return " -C \"" + preloadScript.trim() + "\"";
    }
}

