/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmake;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.cmake.CmakeBuilder;
import hudson.plugins.cmake.CmakeBuilderImpl;
import hudson.plugins.cmake.CmakeLauncher;
import hudson.plugins.cmake.EnvVarReplacer;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class CmakeBuilder
extends Builder {
    private static final String CMAKE_EXECUTABLE = "CMAKE_EXECUTABLE";
    private static final String CMAKE = "cmake";
    private String sourceDir;
    private String buildDir;
    private String installDir;
    private String buildType;
    private String otherBuildType;
    private String generator;
    private String makeCommand;
    private String installCommand;
    private String preloadScript;
    private String cmakeArgs;
    private String projectCmakePath;
    private boolean cleanBuild;
    private boolean cleanInstallDir;
    private CmakeBuilderImpl builderImpl;

    @DataBoundConstructor
    public CmakeBuilder(String sourceDir, String buildDir, String installDir, String buildType, String otherBuildType, boolean cleanBuild, boolean cleanInstallDir, String generator, String makeCommand, String installCommand, String preloadScript, String cmakeArgs, String projectCmakePath) {
        this.sourceDir = sourceDir;
        this.buildDir = buildDir;
        this.installDir = installDir;
        this.buildType = buildType;
        this.otherBuildType = otherBuildType;
        this.cleanBuild = cleanBuild;
        this.cleanInstallDir = cleanInstallDir;
        this.generator = generator;
        this.makeCommand = makeCommand;
        this.installCommand = installCommand;
        this.cmakeArgs = cmakeArgs;
        this.projectCmakePath = projectCmakePath;
        this.preloadScript = preloadScript;
        this.builderImpl = new CmakeBuilderImpl();
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getOtherBuildType() {
        return this.otherBuildType;
    }

    public boolean getCleanBuild() {
        return this.cleanBuild;
    }

    public boolean getCleanInstallDir() {
        return this.cleanInstallDir;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public String getInstallCommand() {
        return this.installCommand;
    }

    public String getPreloadScript() {
        return this.preloadScript;
    }

    public String getCmakeArgs() {
        return this.cmakeArgs;
    }

    public String getProjectCmakePath() {
        return this.projectCmakePath;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String theInstallDir;
        String theSourceDir;
        listener.getLogger().println("MODULE: " + build.getModuleRoot());
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        FilePath workSpace = build.getProject().getWorkspace();
        String theBuildDir = this.buildDir;
        try {
            theBuildDir = this.prepareBuildDir(listener, envs, workSpace);
            theSourceDir = this.prepareSourceDir(envs, workSpace);
            theInstallDir = this.prepareInstallDir(listener, envs, workSpace);
        }
        catch (IOException ioe) {
            listener.getLogger().println(ioe.getMessage());
            return false;
        }
        String theBuildType = this.prepareBuildType();
        listener.getLogger().println("Build   dir  : " + theBuildDir.toString());
        listener.getLogger().println("Source  dir  : " + theSourceDir.toString());
        listener.getLogger().println("Install dir  : " + theInstallDir.toString());
        String cmakeCall = this.prepareCmakeCall(build, listener, envs, theSourceDir, theInstallDir, theBuildType);
        listener.getLogger().println("CMake call : " + cmakeCall);
        CmakeLauncher cmakeLauncher = new CmakeLauncher(launcher, envs, workSpace, listener, theBuildDir);
        try {
            if (!cmakeLauncher.launchCmake(cmakeCall)) {
                return false;
            }
            if (!cmakeLauncher.launchMake(this.getMakeCommand())) {
                return false;
            }
            return cmakeLauncher.launchInstall(this.installDir, this.getInstallCommand());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    private String prepareCmakeCall(AbstractBuild build, BuildListener listener, EnvVars envs, String theSourceDir, String theInstallDir, String theBuildType) throws IOException, InterruptedException {
        String cmakeBin = this.checkCmake(build.getBuiltOn(), listener, envs);
        String cmakeCall = this.builderImpl.buildCMakeCall(cmakeBin, this.generator, this.preloadScript, theSourceDir, theInstallDir, theBuildType, EnvVarReplacer.replace((String)this.cmakeArgs, (Map)envs));
        return EnvVarReplacer.replace((String)cmakeCall, (Map)envs);
    }

    private String prepareBuildType() {
        if (this.otherBuildType != null && this.otherBuildType.length() > 0) {
            return this.otherBuildType;
        }
        return this.buildType;
    }

    private String prepareInstallDir(BuildListener listener, EnvVars envs, FilePath workSpace) throws IOException {
        if (this.cleanInstallDir) {
            listener.getLogger().println("Wiping out install Dir... " + this.installDir);
            return this.getCmakeBuilderImpl().preparePath(workSpace, (Map)envs, this.installDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
        }
        return this.getCmakeBuilderImpl().preparePath(workSpace, (Map)envs, this.installDir, CmakeBuilderImpl.PreparePathOptions.CREATE_IF_NOT_EXISTING);
    }

    private String prepareSourceDir(EnvVars envs, FilePath workSpace) throws IOException {
        return this.getCmakeBuilderImpl().preparePath(workSpace, (Map)envs, this.sourceDir, CmakeBuilderImpl.PreparePathOptions.CHECK_PATH_EXISTS);
    }

    private String prepareBuildDir(BuildListener listener, EnvVars envs, FilePath workSpace) throws IOException {
        if (this.cleanBuild) {
            listener.getLogger().println("Cleaning build Dir... " + this.buildDir);
            return this.getCmakeBuilderImpl().preparePath(workSpace, (Map)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_NEW_IF_EXISTS);
        }
        return this.getCmakeBuilderImpl().preparePath(workSpace, (Map)envs, this.buildDir, CmakeBuilderImpl.PreparePathOptions.CREATE_IF_NOT_EXISTING);
    }

    private CmakeBuilderImpl getCmakeBuilderImpl() {
        if (this.builderImpl == null) {
            this.builderImpl = new CmakeBuilderImpl();
        }
        return this.builderImpl;
    }

    private String checkCmake(Node node, BuildListener listener, EnvVars envs) throws IOException, InterruptedException {
        String cmakeBin = CMAKE;
        String cmakePath = this.getDescriptor().cmakePath();
        if (cmakePath != null && cmakePath.length() > 0) {
            cmakeBin = cmakePath;
        }
        if (this.getProjectCmakePath() != null && this.getProjectCmakePath().length() > 0) {
            cmakeBin = EnvVarReplacer.replace((String)this.getProjectCmakePath(), (Map)envs);
        }
        if (envs.containsKey((Object)CMAKE_EXECUTABLE)) {
            cmakeBin = (String)envs.get((Object)CMAKE_EXECUTABLE);
        }
        Proc proc = node.createLauncher((TaskListener)listener).launch(cmakeBin + " -version", new HashMap(), (OutputStream)listener.getLogger(), node.getRootPath());
        proc.join();
        return cmakeBin;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

