/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

public class BasicHttpVersion
extends HttpVersion {
    public BasicHttpVersion(int major, int minor) {
        super(major, minor);
    }

    public static HttpVersion parse(CharArrayBuffer buffer, int indexFrom, int indexTo) throws ProtocolException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int minor;
            int major;
            int i = indexFrom;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            if (buffer.charAt(i) != 'H' || buffer.charAt(i + 1) != 'T' || buffer.charAt(i + 2) != 'T' || buffer.charAt(i + 3) != 'P' || buffer.charAt(i + 4) != '/') {
                throw new ProtocolException("Not a valid HTTP version string: " + buffer.substring(indexFrom, indexTo));
            }
            int period = buffer.indexOf(46, i += 5, indexTo);
            if (period == -1) {
                throw new ProtocolException("Invalid HTTP version number: " + buffer.substring(indexFrom, indexTo));
            }
            try {
                major = Integer.parseInt(buffer.substringTrimmed(i, period));
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid HTTP major version number: " + buffer.substring(indexFrom, indexTo));
            }
            try {
                minor = Integer.parseInt(buffer.substringTrimmed(period + 1, indexTo));
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid HTTP minor version number: " + buffer.substring(indexFrom, indexTo));
            }
            return new HttpVersion(major, minor);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Invalid HTTP version string: " + buffer.substring(indexFrom, indexTo));
        }
    }

    public static final HttpVersion parse(String s) throws ProtocolException {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return BasicHttpVersion.parse(buffer, 0, buffer.length());
    }

    public static void format(CharArrayBuffer buffer, HttpVersion ver) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (ver == null) {
            throw new IllegalArgumentException("Version may not be null");
        }
        buffer.append("HTTP/");
        buffer.append(Integer.toString(ver.getMajor()));
        buffer.append('.');
        buffer.append(Integer.toString(ver.getMinor()));
    }

    public static String format(HttpVersion ver) {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        BasicHttpVersion.format(buffer, ver);
        return buffer.toString();
    }
}

