/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

public class RequestTargetHost
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = (HttpHost)context.getAttribute("http.target_host");
            if (targethost == null) {
                return;
            }
            String virtualhost = HttpProtocolParams.getVirtualHost(request.getParams());
            if (virtualhost != null) {
                targethost = new HttpHost(virtualhost, targethost.getPort());
            }
            request.addHeader(new Header("Host", targethost.toHostString()));
        }
    }
}

