/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import org.apache.http.HttpVersion;
import org.apache.http.params.HttpParams;

public final class HttpProtocolParams {
    public static final String PROTOCOL_VERSION = "http.protocol.version";
    public static final String CREDENTIAL_CHARSET = "http.protocol.credential-charset";
    public static final String HTTP_ELEMENT_CHARSET = "http.protocol.element-charset";
    public static final String HTTP_CONTENT_CHARSET = "http.protocol.content-charset";
    public static final String USER_AGENT = "http.useragent";
    public static final String ORIGIN_SERVER = "http.origin-server";
    public static final String STATUS_LINE_GARBAGE_LIMIT = "http.protocol.status-line-garbage-limit";
    public static final String DATE_PATTERNS = "http.dateparser.patterns";
    public static final String VIRTUAL_HOST = "http.virtual-host";
    public static final String STRICT_TRANSFER_ENCODING = "http.protocol.strict-transfer-encoding";
    public static final String USE_EXPECT_CONTINUE = "http.protocol.expect-continue";

    private HttpProtocolParams() {
    }

    public static String getHttpElementCharset(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String charset = (String)params.getParameter(HTTP_ELEMENT_CHARSET);
        if (charset == null) {
            charset = "US-ASCII";
        }
        return charset;
    }

    public static void setHttpElementCharset(HttpParams params, String charset) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setParameter(HTTP_ELEMENT_CHARSET, charset);
    }

    public static String getContentCharset(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String charset = (String)params.getParameter(HTTP_CONTENT_CHARSET);
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public static void setContentCharset(HttpParams params, String charset) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setParameter(HTTP_CONTENT_CHARSET, charset);
    }

    public static String getCredentialCharset(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String charset = (String)params.getParameter(CREDENTIAL_CHARSET);
        if (charset == null) {
            charset = HttpProtocolParams.getHttpElementCharset(params);
        }
        return charset;
    }

    public static void setCredentialCharset(HttpParams params, String charset) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setParameter(CREDENTIAL_CHARSET, charset);
    }

    public static HttpVersion getVersion(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Object param = params.getParameter(PROTOCOL_VERSION);
        if (param == null) {
            return HttpVersion.HTTP_1_1;
        }
        return (HttpVersion)param;
    }

    public static void setVersion(HttpParams params, HttpVersion version) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setParameter(PROTOCOL_VERSION, version);
    }

    public static void setVirtualHost(HttpParams params, String hostname) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setParameter(VIRTUAL_HOST, hostname);
    }

    public static String getVirtualHost(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return (String)params.getParameter(VIRTUAL_HOST);
    }

    public static String getUserAgent(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return (String)params.getParameter(USER_AGENT);
    }

    public static void setUserAgent(HttpParams params, String useragent) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setParameter(USER_AGENT, useragent);
    }

    public static boolean useExpectContinue(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getBooleanParameter(USE_EXPECT_CONTINUE, false);
    }

    public static void setUseExpectContinue(HttpParams params, boolean b) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setBooleanParameter(USE_EXPECT_CONTINUE, b);
    }
}

