/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.io.HttpDataReceiver;

public class ContentLengthInputStream
extends InputStream {
    private static int BUFFER_SIZE = 2048;
    private long contentLength;
    private long pos = 0L;
    private boolean closed = false;
    private HttpDataReceiver in = null;

    public ContentLengthInputStream(HttpDataReceiver in, long contentLength) {
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length may not be negative");
        }
        this.in = in;
        this.contentLength = contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                byte[] buffer = new byte[BUFFER_SIZE];
                while (this.read(buffer) >= 0) {
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        ++this.pos;
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        if (this.pos + (long)len > this.contentLength) {
            len = (int)(this.contentLength - this.pos);
        }
        int count = this.in.read(b, off, len);
        this.pos += (long)count;
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        int l;
        if (n <= 0L) {
            return 0L;
        }
        byte[] buffer = new byte[BUFFER_SIZE];
        long count = 0L;
        for (long remaining = Math.min(n, this.contentLength - this.pos); remaining > 0L && (l = this.read(buffer, 0, (int)Math.min((long)BUFFER_SIZE, remaining))) != -1; remaining -= (long)l) {
            count += (long)l;
        }
        this.pos += count;
        return count;
    }
}

