/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.entity.EntitySerializer;
import org.apache.http.io.ChunkedOutputStream;
import org.apache.http.io.ContentLengthOutputStream;
import org.apache.http.io.HttpDataTransmitter;
import org.apache.http.io.IdentityOutputStream;

public class DefaultEntitySerializer
implements EntitySerializer {
    protected OutputStream doSerialize(HttpDataTransmitter datatransmitter, HttpMessage message) throws HttpException, IOException {
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (transferEncodingHeader != null) {
            String s = transferEncodingHeader.getValue();
            if ("chunked".equalsIgnoreCase(s)) {
                if (message.getHttpVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + message.getHttpVersion());
                }
                return new ChunkedOutputStream(datatransmitter);
            }
            if ("identity".equalsIgnoreCase(s)) {
                return new IdentityOutputStream(datatransmitter);
            }
            throw new ProtocolException("Unsupported transfer encoding: " + s);
        }
        if (contentLengthHeader != null) {
            String s = contentLengthHeader.getValue();
            try {
                long len = Long.parseLong(s);
                return new ContentLengthOutputStream(datatransmitter, len);
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid content length: " + s);
            }
        }
        return new IdentityOutputStream(datatransmitter);
    }

    public void serialize(HttpDataTransmitter datatransmitter, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        if (datatransmitter == null) {
            throw new IllegalArgumentException("HTTP data transmitter may not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        OutputStream outstream = this.doSerialize(datatransmitter, message);
        entity.writeTo(outstream);
        outstream.close();
    }
}

