/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import org.apache.http.HttpRequestFactory;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpParams;

public class DefaultServerIOEventDispatch
implements IOEventDispatch {
    private static final String NHTTP_CONN = "NHTTP_CONN";
    private final NHttpServiceHandler handler;
    private final HttpParams params;

    public DefaultServerIOEventDispatch(NHttpServiceHandler handler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handler = handler;
        this.params = params;
    }

    public void connected(IOSession session) {
        DefaultNHttpServerConnection conn = new DefaultNHttpServerConnection(session, (HttpRequestFactory)new DefaultHttpRequestFactory(), this.params);
        session.setAttribute(NHTTP_CONN, conn);
        this.handler.connected(conn);
    }

    public void disconnected(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        this.handler.closed(conn);
    }

    public void inputReady(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        conn.consumeInput(this.handler);
    }

    public void outputReady(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        conn.produceOutput(this.handler);
    }

    public void timeout(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        this.handler.timeout(conn);
    }
}

