/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.io.IOException;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.RequestLine;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.codecs.HttpResponseParser;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public class DefaultNHttpClientConnection
extends NHttpConnectionBase
implements NHttpClientConnection {
    private HttpResponseParser responseParser;

    public DefaultNHttpClientConnection(IOSession session, HttpResponseFactory responseFactory, HttpParams params) {
        super(session, params);
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseParser = new HttpResponseParser(this.inbuf, responseFactory);
        this.hasBufferedInput = false;
        this.hasBufferedOutput = false;
        this.session.setBufferStatus(this);
    }

    private void resetInput() {
        this.response = null;
        this.contentDecoder = null;
        this.responseParser.reset();
    }

    private void resetOutput() {
        this.request = null;
        this.contentEncoder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInput(NHttpClientHandler handler) {
        if (this.closed) {
            this.session.clearEvent(1);
            return;
        }
        try {
            if (this.response == null) {
                int bytesRead = this.responseParser.fillBuffer(this.session.channel());
                this.response = (HttpResponse)this.responseParser.parse();
                if (this.response != null) {
                    handler.responseReceived(this);
                    if (this.response.getStatusLine().getStatusCode() >= 200) {
                        HttpEntity entity = this.prepareDecoder((HttpMessage)this.response);
                        this.response.setEntity(entity);
                    } else {
                        this.responseParser.reset();
                        this.response = null;
                    }
                }
                if (bytesRead == -1) {
                    this.close();
                }
            }
            if (this.contentDecoder != null) {
                handler.inputReady(this, this.contentDecoder);
                if (this.contentDecoder.isCompleted()) {
                    this.resetInput();
                }
            }
        }
        catch (IOException ex) {
            handler.exception((NHttpClientConnection)this, ex);
        }
        catch (HttpException ex) {
            handler.exception((NHttpClientConnection)this, ex);
        }
        finally {
            this.hasBufferedInput = this.inbuf.hasData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceOutput(NHttpClientHandler handler) {
        if (this.request == null && !this.closed) {
            handler.requestReady(this);
        }
        try {
            if (this.outbuf.hasData()) {
                this.outbuf.flush(this.session.channel());
            }
            if (!this.outbuf.hasData()) {
                if (this.closed) {
                    this.session.close();
                    this.resetOutput();
                    return;
                }
                if (this.contentEncoder != null) {
                    handler.outputReady(this, this.contentEncoder);
                    if (this.contentEncoder.isCompleted()) {
                        this.resetOutput();
                    }
                }
                if (this.contentEncoder == null && !this.outbuf.hasData()) {
                    this.session.clearEvent(4);
                }
            }
        }
        catch (IOException ex) {
            handler.exception((NHttpClientConnection)this, ex);
        }
        finally {
            this.hasBufferedOutput = this.outbuf.hasData();
        }
    }

    public void submitRequest(HttpRequest request) throws HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertNotClosed();
        if (this.request != null) {
            throw new HttpException("Request already submitted");
        }
        this.lineBuffer.clear();
        BasicRequestLine.format((CharArrayBuffer)this.lineBuffer, (RequestLine)request.getRequestLine());
        this.outbuf.writeLine(this.lineBuffer);
        Iterator it = request.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            if (header instanceof BufferedHeader) {
                this.outbuf.writeLine(((BufferedHeader)header).getBuffer());
                continue;
            }
            this.lineBuffer.clear();
            BasicHeader.format((CharArrayBuffer)this.lineBuffer, (Header)header);
            this.outbuf.writeLine(this.lineBuffer);
        }
        this.lineBuffer.clear();
        this.outbuf.writeLine(this.lineBuffer);
        if (request instanceof HttpEntityEnclosingRequest) {
            this.prepareEncoder((HttpMessage)request);
            this.request = request;
        }
        this.session.setEvent(4);
    }

    public boolean isRequestSubmitted() {
        return this.request != null;
    }

    public void cancelRequest() {
        this.resetOutput();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.isOpen()) {
            buffer.append(this.session.getRemoteAddress());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

