/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.groovy;

import groovy.xml.SAXBuilder;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.helpers.AttributesImpl;

public class HiveMindBuilder
extends SAXBuilder {
    public static final Locator GROOVY_LOCATOR = new GroovyLocator();
    private static final Map CAMEL_TO_HYPHEN_MAP = new HashMap();

    public HiveMindBuilder(ContentHandler parser) {
        super(parser);
        parser.setDocumentLocator(GROOVY_LOCATOR);
    }

    protected void nodeCompleted(Object parent, Object node) {
        super.nodeCompleted(parent, (Object)this.getHyphenatedName(node.toString()));
    }

    protected void doStartElement(Object name, Attributes attributes) {
        super.doStartElement((Object)this.getHyphenatedName(name.toString()), this.getHyphenatedAttributes(attributes));
    }

    private String getHyphenatedName(String name) {
        String hyphenatedName = (String)CAMEL_TO_HYPHEN_MAP.get(name);
        if (hyphenatedName == null) {
            char[] chars = name.toCharArray();
            StringBuffer hyphenated = new StringBuffer();
            int i = 0;
            while (i < name.length()) {
                if (Character.isUpperCase(chars[i])) {
                    hyphenated.append('-').append(Character.toLowerCase(chars[i]));
                } else {
                    hyphenated.append(chars[i]);
                }
                ++i;
            }
            hyphenatedName = hyphenated.toString();
            CAMEL_TO_HYPHEN_MAP.put(name, hyphenatedName);
        }
        return hyphenatedName;
    }

    private Attributes getHyphenatedAttributes(Attributes attributes) {
        AttributesImpl result = (AttributesImpl)attributes;
        int i = 0;
        while (i < result.getLength()) {
            result.setLocalName(i, this.getHyphenatedName(result.getLocalName(i)));
            ++i;
        }
        return result;
    }

    private static class GroovyLocator
    implements Locator {
        private GroovyLocator() {
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public int getLineNumber() {
            try {
                throw new Throwable();
            }
            catch (Throwable t) {
                trace = t.getStackTrace();
                i = 0;
                ** while (i < trace.length)
            }
lbl-1000:
            // 1 sources

            {
                if (trace[i].getFileName().endsWith(".groovy")) {
                    return trace[i].getLineNumber();
                }
                ++i;
                continue;
            }
lbl11:
            // 1 sources

            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }
    }
}

