/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2x.doc.DocFile;
import org.hibernate.tool.hbm2x.doc.DocFolder;
import org.hibernate.tool.hbm2x.doc.DocHelper;

public class DocFileManager {
    private DocFolder rootDocFolder;
    private DocFile mainIndexDocFile;
    private DocFile headerDocFile;
    private DocFolder assetsDocFolder;
    private DocFile hibernateImageDocFile;
    private DocFile cssStylesDocFile;
    private DocFolder rootTablesDocFolder;
    private DocFile tableIndexDocFile;
    private DocFile tableSummaryDocFile;
    private DocFile allSchemasDocFile;
    private DocFile allTablesDocFile;
    private Map tableDocFiles = new HashMap();
    private Map schemaSummaryDocFiles = new HashMap();
    private Map schemaTableListDocFiles = new HashMap();

    public DocFileManager(DocHelper docHelper, File pRootFolder) {
        Configuration cfg = docHelper.getCfg();
        this.rootDocFolder = new DocFolder(pRootFolder);
        this.mainIndexDocFile = new DocFile("index.html", this.rootDocFolder);
        this.headerDocFile = new DocFile("header.html", this.rootDocFolder);
        this.assetsDocFolder = new DocFolder("assets", this.rootDocFolder);
        this.hibernateImageDocFile = new DocFile("hibernate_logo.gif", this.assetsDocFolder);
        this.cssStylesDocFile = new DocFile("doc-style.css", this.assetsDocFolder);
        this.rootTablesDocFolder = new DocFolder("tables", this.rootDocFolder);
        this.tableIndexDocFile = new DocFile("index.html", this.rootTablesDocFolder);
        this.tableSummaryDocFile = new DocFile("summary.html", this.rootTablesDocFolder);
        this.allSchemasDocFile = new DocFile("allschemas.html", this.rootTablesDocFolder);
        this.allTablesDocFile = new DocFile("alltables.html", this.rootTablesDocFolder);
        HashMap<String, DocFolder> schemaFolders = new HashMap<String, DocFolder>();
        Iterator schemas = docHelper.getSchemas().iterator();
        while (schemas.hasNext()) {
            String schemaName = (String)schemas.next();
            DocFolder schemaFolder = new DocFolder(schemaName, this.rootTablesDocFolder);
            schemaFolders.put(schemaName, schemaFolder);
            DocFile schemaSummaryDocFile = new DocFile("summary.html", schemaFolder);
            this.schemaSummaryDocFiles.put(schemaName, schemaSummaryDocFile);
            DocFile tableListDocFile = new DocFile("tables.html", schemaFolder);
            this.schemaTableListDocFiles.put(schemaName, tableListDocFile);
            Iterator tables = docHelper.getTables(schemaName).iterator();
            while (tables.hasNext()) {
                Table table = (Table)tables.next();
                String tableFileName = table.getName() + ".html";
                DocFile tableDocFile = new DocFile(tableFileName, schemaFolder);
                this.tableDocFiles.put(table, tableDocFile);
            }
        }
    }

    public DocFolder getAssetsDocFolder() {
        return this.assetsDocFolder;
    }

    public DocFile getCssStylesDocFile() {
        return this.cssStylesDocFile;
    }

    public DocFile getHeaderDocFile() {
        return this.headerDocFile;
    }

    public DocFile getHibernateImageDocFile() {
        return this.hibernateImageDocFile;
    }

    public DocFile getMainIndexDocFile() {
        return this.mainIndexDocFile;
    }

    public DocFile getTableIndexDocFile() {
        return this.tableIndexDocFile;
    }

    public DocFile getTableSummaryDocFile() {
        return this.tableSummaryDocFile;
    }

    public DocFile getAllSchemasDocFile() {
        return this.allSchemasDocFile;
    }

    public DocFile getAllTablesDocFile() {
        return this.allTablesDocFile;
    }

    public DocFile getTableDocFile(Table table) {
        return (DocFile)this.tableDocFiles.get(table);
    }

    public DocFile getSchemaSummaryDocFile(String schemaName) {
        return (DocFile)this.schemaSummaryDocFiles.get(schemaName);
    }

    public DocFile getSchemaTableListDocFile(String schemaName) {
        return (DocFile)this.schemaTableListDocFiles.get(schemaName);
    }

    public String getRef(DocFile from, DocFile to) {
        if (from == null) {
            throw new IllegalArgumentException("From cannot be null.");
        }
        if (to == null) {
            throw new IllegalArgumentException("To cannot be null.");
        }
        return from.buildRefTo(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String fileName, File to) throws IOException {
        FileOutputStream out;
        block9: {
            InputStream is = null;
            out = null;
            try {
                int value;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = DocFileManager.class.getClassLoader();
                }
                if ((is = classLoader.getResourceAsStream(fileName)) == null && classLoader != DocFileManager.class.getClassLoader()) {
                    is = DocFileManager.class.getClassLoader().getResourceAsStream(fileName);
                }
                if (is == null) {
                    throw new IllegalArgumentException("File not found: " + fileName);
                }
                out = new FileOutputStream(to);
                while ((value = is.read()) != -1) {
                    out.write(value);
                }
                Object var7_6 = null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (out != null) {
            out.close();
        }
    }
}

