/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.tool.hbm2x.ExporterException;
import org.w3c.tidy.Tidy;

public class XMLPrettyPrinter {
    private static final Log log = LogFactory.getLog((Class)XMLPrettyPrinter.class);

    public static void prettyPrint(InputStream in, OutputStream writer) throws IOException {
        Tidy tidy = XMLPrettyPrinter.getDefaultTidy();
        tidy.parse(in, writer);
    }

    static Tidy getDefaultTidy() throws IOException {
        Tidy tidy = new Tidy();
        tidy.setErrout(new PrintWriter(new Writer(){

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
            }
        }));
        Properties properties = new Properties();
        properties.load(XMLPrettyPrinter.class.getResourceAsStream("jtidy.properties"));
        tidy.setConfigurationFromProps(properties);
        return tidy;
    }

    public static void prettyPrintFiles(Tidy tidy, File[] inputfiles, File[] outputfiles) throws IOException {
        if (inputfiles == null || outputfiles == null || inputfiles.length != outputfiles.length) {
            throw new IllegalArgumentException("inputfiles and outputfiles must be not null and have equal length.");
        }
        for (int i = 0; i < outputfiles.length; ++i) {
            XMLPrettyPrinter.prettyPrintFile(tidy, inputfiles[i], outputfiles[i]);
        }
    }

    public static void prettyPrintFile(Tidy tidy, File inputFile, File outputFile) throws IOException {
        log.debug((Object)("XMLPrettyPrinting " + inputFile.getAbsolutePath()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inputFile));
        outputFile.getParentFile().mkdirs();
        outputFile.createNewFile();
        BufferedOutputStream os = new BufferedOutputStream(bos);
        tidy.parse((InputStream)is, (OutputStream)os);
        byte[] bs = bos.toByteArray();
        try {
            ((InputStream)is).close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (tidy.getParseErrors() == 0) {
            int len;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
            ByteArrayInputStream in = new ByteArrayInputStream(bs);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            ((InputStream)in).close();
            out.close();
        }
        if (tidy.getParseErrors() > 0) {
            throw new ExporterException("Tidy was unable to process file " + inputFile + ", " + tidy.getParseErrors() + " returned.");
        }
    }

    public static void prettyPrintDirectory(File outputdir, final String prefix) throws IOException {
        File[] files = outputdir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(prefix);
            }
        });
        Tidy tidy = XMLPrettyPrinter.getDefaultTidy();
        XMLPrettyPrinter.prettyPrintFiles(tidy, files, files);
    }
}

