/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ConfigurationNavigator;
import org.hibernate.tool.hbm2x.ExporterException;

public class POJOExporter
extends AbstractExporter {
    private static final String POJO_JAVACLASS_VM = "pojo/javaclass.vm";
    private static final Log log = LogFactory.getLog((Class)POJOExporter.class);
    private StringWriter tempWriter;
    String templateName = "pojo/javaclass.vm";
    private boolean ejb3;
    private boolean generics;

    public POJOExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public POJOExporter() {
    }

    public boolean useEjb3() {
        return this.ejb3;
    }

    public void setEjb3(boolean ejb3) {
        this.ejb3 = ejb3;
    }

    public boolean useGenerics() {
        return this.generics;
    }

    public void setGenerics(boolean generics) {
        this.generics = generics;
    }

    protected String getNameForClass(PersistentClass clazz) {
        return this.getTemplateHelper().getCfg2JavaTool().getQualifiedDeclarationName(clazz);
    }

    public void exportPersistentClass(PersistentClass clazz) {
        this.runVelocity(clazz, this.getNameForClass(clazz), this.templateName);
    }

    public void exportComponent(Component component) throws ExporterException {
        if (component.getComponentClassName().indexOf(36) >= 0) {
            log.warn((Object)"hbm2java does not support generation of inner classes.");
        } else {
            String nameForComponent = this.getTemplateHelper().getCfg2JavaTool().getQualifiedDeclarationName(component);
            this.runVelocity(component, nameForComponent, this.templateName);
        }
    }

    protected void runVelocity(Object clazz, String qualifiedDeclarationName, String templateName) {
        this.tempWriter = new StringWriter();
        this.getTemplateHelper().putInContext("clazz", clazz);
        this.getTemplateHelper().putInContext("secondpassclassimports", "$secondpassclassimports");
        this.getTemplateHelper().processTemplate(templateName, this.tempWriter);
        this.getTemplateHelper().removeFromContext("secondpassclassimports", "$secondpassclassimports");
        try {
            String o = (String)this.getTemplateHelper().getContext().get("classimports");
            if (o == null) {
                o = "";
            }
            this.getTemplateHelper().putInContext("secondpassclassimports", o);
            File file = POJOExporter.getFileForClassName(this.getOutputDirectory(), qualifiedDeclarationName, ".java");
            log.info((Object)("Writing " + qualifiedDeclarationName + " to " + file.getAbsolutePath()));
            FileWriter fileWriter = new FileWriter(file);
            this.getTemplateHelper().processString(this.tempWriter.toString(), fileWriter);
            this.getTemplateHelper().removeFromContext("secondpassclassimports", o);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            throw new ExporterException("Error while processing template the second time", e);
        }
        this.getTemplateHelper().removeFromContext("clazz", clazz);
    }

    public void start() {
        this.setupTemplates();
        this.getTemplateHelper().putInContext("cfg", this.getConfiguration());
        this.getTemplateHelper().putInContext("ejb3", this.ejb3);
        this.getTemplateHelper().putInContext("generics", this.generics);
        HashMap components = new HashMap();
        Iterator classes = this.getConfiguration().getClassMappings();
        while (classes.hasNext()) {
            PersistentClass clazz = (PersistentClass)classes.next();
            ConfigurationNavigator.collectComponents(components, clazz);
            this.exportPersistentClass(clazz);
        }
        Iterator comps = components.values().iterator();
        while (comps.hasNext()) {
            Component component = (Component)comps.next();
            this.exportComponent(component);
        }
        this.setTemplateHelper(null);
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }
}

