/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractExporter
implements Exporter {
    private File outputdir;
    private Configuration configuration;
    protected String[] templatePaths;
    private TemplateHelper vh;

    public AbstractExporter(Configuration cfg, File outputdir) {
        this.setConfiguration(cfg);
        this.setOutputDir(outputdir);
    }

    public AbstractExporter() {
    }

    public void setOutputDir(File outputdir) {
        this.outputdir = outputdir;
    }

    public void setConfiguration(Configuration cfg) {
        this.configuration = cfg;
    }

    protected static File getFileForClassName(File baseDir, String className, String extension) {
        String filename = StringHelper.unqualify((String)className) + extension;
        String packagename = StringHelper.qualifier((String)className);
        return new File(AbstractExporter.getDirForPackage(baseDir, packagename), filename);
    }

    private static File getDirForPackage(File baseDir, String packageName) {
        File dir = null;
        String p = packageName == null ? "" : packageName;
        dir = new File(baseDir, p.replace('.', File.separatorChar));
        if (dir.exists() && !dir.isDirectory()) {
            throw new ExporterException("The path: " + dir.getAbsolutePath() + " exists, but is not a directory");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new ExporterException("unable to create directory: " + dir.getAbsolutePath());
        }
        return dir;
    }

    public File getOutputDirectory() {
        return this.outputdir;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void start() {
    }

    public String[] getTemplatePaths() {
        return this.templatePaths;
    }

    public void setTemplatePaths(String[] templatePaths) {
        this.templatePaths = templatePaths;
    }

    protected void setupTemplates() {
        this.setTemplateHelper(new TemplateHelper());
        this.getTemplateHelper().init(this.templatePaths);
    }

    protected void setTemplateHelper(TemplateHelper vh) {
        this.vh = vh;
    }

    protected TemplateHelper getTemplateHelper() {
        return this.vh;
    }
}

