/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.dataseed;

import java.util.List;
import java.util.Random;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class DataSeed {
    Random r = new Random();

    public void seed(Configuration cfg, Session s, String entityName, long createCount) {
        SessionFactory sf = s.getSessionFactory();
        ClassMetadata classMetadata = sf.getClassMetadata(entityName);
        for (long cnt = 0L; cnt < createCount; ++cnt) {
            Object object = classMetadata.instantiate(null, EntityMode.POJO);
            String[] propertyNames = classMetadata.getPropertyNames();
            Type[] propertyTypes = classMetadata.getPropertyTypes();
            boolean[] propertyNullability = classMetadata.getPropertyNullability();
            for (int i = 0; i < propertyNames.length; ++i) {
                String name = propertyNames[i];
                Type type = propertyTypes[i];
                boolean canBeNull = propertyNullability[i];
                Object value = this.generate(s, propertyTypes[i], cnt);
                System.out.println("Setting " + name + " to " + value);
                classMetadata.setPropertyValue(object, name, value, EntityMode.POJO);
            }
            System.out.println(cnt + ":" + object);
            s.save(object);
        }
    }

    private Object generate(Session s, Type type, long count) {
        if (type.isCollectionType()) {
            CollectionType ct = (CollectionType)type;
            return ct.instantiate(null);
        }
        if (type.isEntityType()) {
            EntityType et = (EntityType)type;
            String associatedEntityName = et.getAssociatedEntityName();
            List list = s.createCriteria(associatedEntityName).list();
            if (list.isEmpty()) {
                return null;
            }
            return list.get(this.r.nextInt(list.size()));
        }
        Class returnedClass = type.getReturnedClass();
        if (returnedClass == Integer.class) {
            return new Integer(this.r.nextInt((int)count));
        }
        if (returnedClass == Double.class) {
            return new Double(this.r.nextDouble());
        }
        if (returnedClass == String.class) {
            return new String("Str " + count);
        }
        throw new IllegalStateException("nyi on " + type);
    }
}

