/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.TableFilter;

public class OverrideBinder {
    public static void bindRoot(OverrideRepository repository, Document doc) {
        Element rootElement = doc.getRootElement();
        Element element = rootElement.element("type-mapping");
        if (element != null) {
            OverrideBinder.bindTypeMappings(element, repository);
        }
        List filters = rootElement.elements("table-filter");
        OverrideBinder.bindTableFilters(filters, repository);
    }

    private static void bindTableFilters(List filters, OverrideRepository respository) {
        Iterator iterator = filters.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            TableFilter filter = new TableFilter();
            filter.setMatchCatalog(element.attributeValue("match-catalog"));
            filter.setMatchSchema(element.attributeValue("match-schema"));
            filter.setMatchName(element.attributeValue("match-name"));
            filter.setExclude(Boolean.valueOf(element.attributeValue("exclude")));
            respository.addTableFilter(filter);
        }
    }

    private static void bindTypeMappings(Element typeMapping, OverrideRepository repository) {
        Iterator iterator = typeMapping.elements("sql-type").iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            SQLTypeMapping mapping = new SQLTypeMapping(JDBCToHibernateTypeHelper.getJDBCType(element.attributeValue("jdbc-type")));
            mapping.setHibernateType(element.attributeValue("hibernate-type"));
            mapping.setLength(OverrideBinder.getInteger(element.attributeValue("length"), Integer.MAX_VALUE));
            mapping.setPrecision(OverrideBinder.getInteger(element.attributeValue("precision"), Integer.MAX_VALUE));
            mapping.setScale(OverrideBinder.getInteger(element.attributeValue("scale"), Integer.MAX_VALUE));
            repository.addTypeMapping(mapping);
        }
    }

    private static int getInteger(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        return Integer.parseInt(string);
    }
}

