/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hibernate.ejb.xml.PersistenceXml;
import org.hibernate.ejb.xml.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PersistenceXmlLoader {
    private static Document loadURL(URL configURL) throws Exception {
        InputStream is;
        InputStream inputStream = is = configURL != null ? configURL.openStream() : null;
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        DocumentBuilderFactory docBuilderFactory = null;
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        InputSource source = new InputSource(is);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(source);
        return doc;
    }

    public static PersistenceXml deploy(URL url) throws Exception {
        Document doc = PersistenceXmlLoader.loadURL(url);
        Element top = doc.getDocumentElement();
        PersistenceXml xml = new PersistenceXml();
        NodeList children = top.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (tag.equals("name")) {
                xml.name = XmlHelper.getElementContent(element);
                continue;
            }
            if (tag.equals("non-jta-data-source")) {
                xml.datasource = XmlHelper.getElementContent(element);
                continue;
            }
            if (tag.equals("jta-data-source")) {
                xml.jtaDatasource = XmlHelper.getElementContent(element);
                continue;
            }
            if (tag.equals("provider")) {
                xml.provider = XmlHelper.getElementContent(element);
                continue;
            }
            if (tag.equals("class")) {
                xml.classes.add(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("mapping-file")) {
                xml.mappingFiles.add(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("jar-file")) {
                xml.jarFiles.add(XmlHelper.getElementContent(element));
                continue;
            }
            if (!tag.equals("properties")) continue;
            NodeList props = element.getChildNodes();
            for (int j = 0; j < props.getLength(); ++j) {
                Element propElement;
                if (props.item(j).getNodeType() != 1 || !"property".equals((propElement = (Element)props.item(j)).getTagName())) continue;
                String propName = propElement.getAttribute("name").trim();
                String propValue = propElement.getAttribute("value").trim();
                xml.props.put(propName, propValue);
            }
        }
        return xml;
    }
}

