/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import javax.persistence.PersistenceContextType;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.callback.EntityCallbackHandler;
import org.hibernate.ejb.callback.EntityCallbackInterceptor;
import org.hibernate.engine.SessionImplementor;

public class EntityManagerImpl
extends AbstractEntityManagerImpl {
    private EntityCallbackHandler callbackHandler;
    protected Session session;
    protected SessionFactory sessionFactory;
    protected boolean open;

    public EntityManagerImpl(SessionFactory sessionFactory, PersistenceContextType type, EntityCallbackHandler handler) {
        super(type);
        this.sessionFactory = sessionFactory;
        this.open = true;
        this.callbackHandler = handler;
    }

    public Session getSession() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if (this.session == null) {
            this.session = this.sessionFactory.openSession((Interceptor)new EntityCallbackInterceptor(this.callbackHandler));
            if (this.type == PersistenceContextType.TRANSACTION) {
                ((SessionImplementor)this.session).setAutoClear(true);
            }
        }
        return this.session;
    }

    public void close() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        this.open = false;
        if (this.session != null) {
            this.session.close();
        }
    }

    public boolean isOpen() {
        return this.open;
    }
}

