/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.hexagonkt.http.client.Client;
import com.hexagonkt.http.client.ClientPackageKt;
import com.hexagonkt.serialization.Json;
import com.hexagonkt.serialization.SerializationKt;
import java.io.File;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.asynchttpclient.Response;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Test
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012J\b\u0010\u001d\u001a\u00020\u0012H\u0007J\b\u0010\u001e\u001a\u00020\u0012H\u0007J\u0006\u0010\u001f\u001a\u00020\u0012R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/hexagonkt/http/client/ClientTest;", "", "()V", "client", "Lcom/hexagonkt/http/client/Client;", "getClient", "()Lcom/hexagonkt/http/client/Client;", "client$delegate", "Lkotlin/Lazy;", "templateTransformer", "Lcom/github/tomakehurst/wiremock/extension/responsetemplating/ResponseTemplateTransformer;", "wmExtensions", "Lcom/github/tomakehurst/wiremock/core/WireMockConfiguration;", "kotlin.jvm.PlatformType", "wmOptions", "wmServer", "Lcom/github/tomakehurst/wiremock/WireMockServer;", "checkResponse", "", "response", "Lorg/asynchttpclient/Response;", "parameter", "", "", "files are sent in base64", "http methods with objects work ok", "http methods with objects work ok with default client", "json requests works as expected", "parameters are set properly", "shutdown", "startup", "strings are sent properly", "port_http_client"})
public final class ClientTest {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ResponseTemplateTransformer templateTransformer = new ResponseTemplateTransformer(true);
    private final WireMockConfiguration wmExtensions = WireMockConfiguration.options().extensions(new Extension[]{(Extension)this.templateTransformer});
    private final WireMockConfiguration wmOptions;
    private final WireMockServer wmServer;
    private final Lazy client$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ClientTest.class), "client", "getClient()Lcom/hexagonkt/http/client/Client;"))};
    }

    private final Client getClient() {
        Lazy lazy = this.client$delegate;
        ClientTest clientTest = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Client)lazy.getValue();
    }

    @BeforeClass
    public final void startup() {
        this.wmServer.start();
        WireMock.configureFor((int)this.wmServer.port());
        ResponseDefinitionBuilder resp = WireMock.aResponse().withHeader("content-type", new String[]{"application/json;charset=utf-8"}).withBody("{{{request.body}}}");
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.head((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.delete((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.trace((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.options((UrlPattern)WireMock.anyUrl()).willReturn(resp));
        WireMock.stubFor((MappingBuilder)WireMock.patch((UrlPattern)WireMock.anyUrl()).willReturn(resp));
    }

    @AfterClass
    public final void shutdown() {
        this.wmServer.stop();
    }

    public final void json requests works as expected() {
        String string;
        String body2;
        String string2;
        String body;
        String expectedBody = "{\n  \"foo\" : \"fighters\",\n  \"es\" : \"\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\"\n}";
        Map requestBody = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"foo", (Object)"fighters"), TuplesKt.to((Object)"es", (Object)"\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1")});
        String string3 = body = this.getClient().post("/", (Object)requestBody, Json.INSTANCE.getContentType()).getResponseBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"body");
        String string4 = string2 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        boolean bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string4)).toString(), (Object)expectedBody);
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string5));
        }
        String string6 = body2 = Client.post$default((Client)this.getClient(), (String)"/", (Object)requestBody, null, (int)4, null).getResponseBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"body2");
        String string7 = string = string6;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        boolean bl2 = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string7)).toString(), (Object)expectedBody);
        if (_Assertions.ENABLED && !bl2) {
            String string8 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string8));
        }
        Client.get$default((Client)this.getClient(), (String)"/", null, (int)2, null);
        Client.get$default((Client)this.getClient(), (String)"/", null, (int)2, null);
    }

    public final void http methods with objects work ok() {
        Map parameter = MapsKt.mapOf((Pair)TuplesKt.to((Object)"key", (Object)"value"));
        this.checkResponse(Client.get$default((Client)this.getClient(), (String)"/", null, (int)2, null), null);
        this.checkResponse(Client.head$default((Client)this.getClient(), (String)"/", null, (int)2, null), null);
        this.checkResponse(Client.post$default((Client)this.getClient(), (String)"/", (Object)parameter, null, (int)4, null), parameter);
        this.checkResponse(Client.put$default((Client)this.getClient(), (String)"/", (Object)parameter, null, (int)4, null), parameter);
        this.checkResponse(Client.delete$default((Client)this.getClient(), (String)"/", (Object)parameter, null, (int)4, null), parameter);
        this.checkResponse(Client.trace$default((Client)this.getClient(), (String)"/", (Object)parameter, null, (int)4, null), parameter);
        this.checkResponse(Client.options$default((Client)this.getClient(), (String)"/", (Object)parameter, null, (int)4, null), parameter);
        this.checkResponse(Client.patch$default((Client)this.getClient(), (String)"/", (Object)parameter, null, (int)4, null), parameter);
    }

    public final void http methods with objects work ok with default client() {
        Map parameter = MapsKt.mapOf((Pair)TuplesKt.to((Object)"key", (Object)"value"));
        String url = "http://localhost:" + this.wmServer.port();
        String contentType = Json.INSTANCE.getContentType();
        this.checkResponse(ClientPackageKt.get$default((String)url, null, (int)2, null), null);
        this.checkResponse(ClientPackageKt.head$default((String)url, null, (int)2, null), null);
        this.checkResponse(ClientPackageKt.post((String)url, (Object)parameter, (String)contentType), parameter);
        this.checkResponse(ClientPackageKt.put((String)url, (Object)parameter, (String)contentType), parameter);
        this.checkResponse(ClientPackageKt.delete((String)url, (Object)parameter, (String)contentType), parameter);
        this.checkResponse(ClientPackageKt.trace((String)url, (Object)parameter, (String)contentType), parameter);
        this.checkResponse(ClientPackageKt.options((String)url, (Object)parameter, (String)contentType), parameter);
        this.checkResponse(ClientPackageKt.patch((String)url, (Object)parameter, (String)contentType), parameter);
    }

    public final void parameters are set properly() {
        String endpoint = "http://localhost:" + this.wmServer.port();
        Map h = MapsKt.mapOf((Pair)TuplesKt.to((Object)"header1", (Object)CollectionsKt.listOf((Object[])new String[]{"val1", "val2"})));
        Client c = new Client(endpoint, Json.INSTANCE.getContentType(), false, h, "user", "password", true);
        boolean bl = Intrinsics.areEqual((Object)c.getContentType(), (Object)Json.INSTANCE.getContentType());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl2 = bl = !c.getUseCookies();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = Intrinsics.areEqual((Object)c.getHeaders(), (Object)h);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String rn = "request.headers.header1";
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/auth").willReturn(WireMock.aResponse().withHeader("auth", new String[]{"{{request.headers.Authorization}}"}).withHeader("head1", new String[]{"{{" + rn + ".[0]}}{{" + rn + ".[1]}}"})));
        Response r = Client.get$default((Client)c, (String)"/auth", null, (int)2, null);
        String string = r.getHeaders().get("auth");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"r.headers.get(\"auth\")");
        boolean bl3 = StringsKt.startsWith$default((String)string, (String)"Basic", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl3) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        String string3 = r.getHeaders().get("head1");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"r.headers.get(\"head1\")");
        bl3 = StringsKt.contains$default((CharSequence)string3, (CharSequence)"val1", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl3) {
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        String string5 = r.getHeaders().get("head1");
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"r.headers.get(\"head1\")");
        bl3 = StringsKt.contains$default((CharSequence)string5, (CharSequence)"val2", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl3) {
            String string6 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string6));
        }
        boolean bl4 = bl3 = r.getStatusCode() == 200;
        if (_Assertions.ENABLED && !bl3) {
            String string7 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string7));
        }
    }

    public final void files are sent in base64() {
        boolean bl;
        File file;
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/file").willReturn(WireMock.aResponse().withHeader("file64", new String[]{"{{request.body}}"})));
        File it = file = new File("src/test/resources/logback-test.xml");
        boolean bl2 = false;
        File file2 = it.exists() ? it : new File("port_http_client/src/test/resources/logback-test.xml");
        Response r = Client.post$default((Client)this.getClient(), (String)"/file", (Object)file2, null, (int)4, null);
        String string = r.getHeaders().get("file64");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"r.headers.get(\"file64\")");
        CharSequence charSequence = string;
        boolean bl3 = bl = charSequence.length() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        boolean bl4 = bl = r.getStatusCode() == 200;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
    }

    public final void strings are sent properly() {
        boolean bl;
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/string").willReturn(WireMock.aResponse().withHeader("body", new String[]{"{{request.body}}"})));
        Response r = Client.post$default((Client)this.getClient(), (String)"/string", (Object)"text", null, (int)4, null);
        String string = r.getHeaders().get("body");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"r.headers.get(\"body\")");
        CharSequence charSequence = string;
        boolean bl2 = bl = charSequence.length() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        boolean bl3 = bl = r.getStatusCode() == 200;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
    }

    private final void checkResponse(Response response, Map<String, String> parameter) {
        Object object;
        String string;
        block8: {
            block7: {
                boolean bl;
                boolean bl2 = bl = response.getStatusCode() == 200;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                String string3 = response.getResponseBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"response.responseBody");
                Object object2 = string3;
                String string4 = object2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                object = parameter;
                if (object == null || (object = SerializationKt.serialize$default((Object)object, null, (int)1, null)) == null) break block7;
                object2 = object;
                String string5 = string;
                Object object3 = object2;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string6 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
                string = string5;
                object = string6;
                if (object != null) break block8;
            }
            object = "";
        }
        boolean bl = Intrinsics.areEqual((Object)string, (Object)object);
        if (_Assertions.ENABLED && !bl) {
            String string7 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string7));
        }
    }

    public ClientTest() {
        WireMockConfiguration wireMockConfiguration = this.wmExtensions.dynamicPort();
        Intrinsics.checkExpressionValueIsNotNull((Object)wireMockConfiguration, (String)"wmExtensions.dynamicPort()");
        this.wmOptions = wireMockConfiguration;
        this.wmServer = new WireMockServer((Options)this.wmOptions);
        this.client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Client>(this){
            final /* synthetic */ ClientTest this$0;

            @NotNull
            public final Client invoke() {
                return new Client("http://localhost:" + ClientTest.access$getWmServer$p(this.this$0).port(), Json.INSTANCE.getContentType(), false, null, null, null, false, 124, null);
            }
            {
                this.this$0 = clientTest;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ WireMockServer access$getWmServer$p(ClientTest $this) {
        return $this.wmServer;
    }
}

