/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.messaging.rabbitmq;

import com.hexagonkt.helpers.HelpersKt;
import com.hexagonkt.helpers.Logger;
import com.hexagonkt.http.HttpKt;
import com.hexagonkt.messaging.rabbitmq.Handler;
import com.hexagonkt.messaging.rabbitmq.RabbitMqClient;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 72\u00020\u0001:\u00017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019J\u0016\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019J\b\u0010 \u001a\u00020\u0017H\u0016JB\u0010!\u001a\u00020\u0017\"\b\b\u0000\u0010\"*\u00020#2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u00020\u00170'JD\u0010!\u001a\u00020\u0017\"\b\b\u0000\u0010\"*\u00020#\"\b\b\u0001\u0010(*\u00020#2\u0006\u0010)\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H(0'J\b\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0019J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0019JF\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\b\u00101\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020\u00192\b\u00102\u001a\u0004\u0018\u00010\u00192\b\u00103\u001a\u0004\u0018\u00010\u0019H\u0002J*\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0019J\"\u0010/\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0019J'\u00104\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002H\"0'H\u0002\u00a2\u0006\u0002\u00106R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/hexagonkt/messaging/rabbitmq/RabbitMqClient;", "Ljava/io/Closeable;", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "connectionFactory", "Lcom/rabbitmq/client/ConnectionFactory;", "poolSize", "", "(Lcom/rabbitmq/client/ConnectionFactory;I)V", "connected", "", "getConnected", "()Z", "connection", "Lcom/rabbitmq/client/Connection;", "count", "log", "Lcom/hexagonkt/helpers/Logger;", "threadPool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "bindExchange", "", "exchange", "", "exchangeType", "routingKey", "queue", "call", "requestQueue", "message", "close", "consume", "T", "", "type", "Lkotlin/reflect/KClass;", "handler", "Lkotlin/Function1;", "R", "queueName", "createChannel", "Lcom/rabbitmq/client/Channel;", "declareQueue", "name", "deleteQueue", "publish", "channel", "encoding", "correlationId", "replyQueueName", "withChannel", "callback", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "messaging_rabbitmq"})
public final class RabbitMqClient
implements Closeable {
    private final Logger log;
    private volatile int count;
    private final ExecutorService threadPool;
    private Connection connection;
    private final ConnectionFactory connectionFactory;
    private final int poolSize;
    public static final Companion Companion = new Companion(null);

    public final boolean getConnected() {
        Connection connection = this.connection;
        return connection != null ? connection.isOpen() : false;
    }

    @Override
    public void close() {
        Connection connection = this.connection;
        if (connection != null) {
            connection.close();
        }
        this.connection = null;
        this.log.info((Function0)close.1.INSTANCE);
    }

    public final void declareQueue(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.withChannel((Function1)new Function1<Channel, AMQP.Queue.DeclareOk>(name){
            final /* synthetic */ String $name;

            public final AMQP.Queue.DeclareOk invoke(@NotNull Channel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.queueDeclare(this.$name, false, false, false, null);
            }
            {
                this.$name = string;
                super(1);
            }
        });
    }

    public final void deleteQueue(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.withChannel((Function1)new Function1<Channel, AMQP.Queue.DeleteOk>(name){
            final /* synthetic */ String $name;

            public final AMQP.Queue.DeleteOk invoke(@NotNull Channel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.queueDelete(this.$name);
            }
            {
                this.$name = string;
                super(1);
            }
        });
    }

    public final void bindExchange(@NotNull String exchange, @NotNull String exchangeType, @NotNull String routingKey, @NotNull String queue) {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        Intrinsics.checkParameterIsNotNull((Object)exchangeType, (String)"exchangeType");
        Intrinsics.checkParameterIsNotNull((Object)routingKey, (String)"routingKey");
        Intrinsics.checkParameterIsNotNull((Object)queue, (String)"queue");
        this.withChannel((Function1)new Function1<Channel, AMQP.Queue.BindOk>(queue, exchange, exchangeType, routingKey){
            final /* synthetic */ String $queue;
            final /* synthetic */ String $exchange;
            final /* synthetic */ String $exchangeType;
            final /* synthetic */ String $routingKey;

            public final AMQP.Queue.BindOk invoke(@NotNull Channel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.queueDeclare(this.$queue, false, false, false, null);
                it.exchangeDeclare(this.$exchange, this.$exchangeType, false, false, false, null);
                return it.queueBind(this.$queue, this.$exchange, this.$routingKey);
            }
            {
                this.$queue = string;
                this.$exchange = string2;
                this.$exchangeType = string3;
                this.$routingKey = string4;
                super(1);
            }
        });
    }

    public final <T> void consume(@NotNull String exchange, @NotNull String routingKey, @NotNull KClass<T> type, @NotNull Function1<? super T, Unit> handler) {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        Intrinsics.checkParameterIsNotNull((Object)routingKey, (String)"routingKey");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.withChannel((Function1)new Function1<Channel, AMQP.Queue.BindOk>(routingKey, exchange){
            final /* synthetic */ String $routingKey;
            final /* synthetic */ String $exchange;

            public final AMQP.Queue.BindOk invoke(@NotNull Channel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.queueDeclare(this.$routingKey, false, false, false, null);
                return it.queueBind(this.$routingKey, this.$exchange, this.$routingKey);
            }
            {
                this.$routingKey = string;
                this.$exchange = string2;
                super(1);
            }
        });
        this.consume(routingKey, type, handler);
    }

    public final <T, R> void consume(@NotNull String queueName, @NotNull KClass<T> type, @NotNull Function1<? super T, ? extends R> handler) {
        Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        Channel channel = this.createChannel();
        ExecutorService executorService = this.threadPool;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"threadPool");
        Handler<? super T, ? extends R> callback = new Handler<T, R>(this.connectionFactory, channel, executorService, type, handler);
        channel.basicConsume(queueName, false, (Consumer)callback);
        this.log.info((Function0)new Function0<String>(queueName){
            final /* synthetic */ String $queueName;

            @NotNull
            public final String invoke() {
                return "Consuming messages in " + this.$queueName;
            }
            {
                this.$queueName = string;
                super(0);
            }
        });
    }

    private final Channel createChannel() {
        return (Channel)HelpersKt.retry((int)3, (long)50L, (Function0)((Function0)new Function0<Channel>(this){
            final /* synthetic */ RabbitMqClient this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Channel invoke() {
                void var1_1;
                Connection connection;
                Connection connection2 = RabbitMqClient.access$getConnection$p(this.this$0);
                if (connection2 == null || !connection2.isOpen()) {
                    RabbitMqClient.access$setConnection$p(this.this$0, RabbitMqClient.access$getConnectionFactory$p(this.this$0).newConnection());
                    RabbitMqClient.access$getLog$p(this.this$0).warn((Function0)createChannel.1.INSTANCE);
                }
                if ((connection = RabbitMqClient.access$getConnection$p(this.this$0)) == null || (connection = connection.createChannel()) == null) {
                    Channel channel = (Channel)HelpersKt.getError();
                    throw null;
                }
                Connection channel = connection;
                channel.basicQos(RabbitMqClient.access$getPoolSize$p(this.this$0));
                return var1_1;
            }
            {
                this.this$0 = rabbitMqClient;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withChannel(Function1<? super Channel, ? extends T> callback) {
        Channel channel = null;
        try {
            channel = this.createChannel();
            Object object = callback.invoke((Object)channel);
            return (T)object;
        }
        finally {
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
        }
    }

    public final void publish(@NotNull String queue, @NotNull String message, @Nullable String correlationId) {
        Intrinsics.checkParameterIsNotNull((Object)queue, (String)"queue");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.publish("", queue, message, correlationId);
    }

    public static /* synthetic */ void publish$default(RabbitMqClient rabbitMqClient, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        rabbitMqClient.publish(string, string2, string3);
    }

    public final void publish(@NotNull String exchange, @NotNull String routingKey, @NotNull String message, @Nullable String correlationId) {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        Intrinsics.checkParameterIsNotNull((Object)routingKey, (String)"routingKey");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.withChannel((Function1)new Function1<Channel, Unit>(this, exchange, routingKey, message, correlationId){
            final /* synthetic */ RabbitMqClient this$0;
            final /* synthetic */ String $exchange;
            final /* synthetic */ String $routingKey;
            final /* synthetic */ String $message;
            final /* synthetic */ String $correlationId;

            public final void invoke(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                RabbitMqClient.access$publish(this.this$0, channel, this.$exchange, this.$routingKey, null, this.$message, this.$correlationId, null);
            }
            {
                this.this$0 = rabbitMqClient;
                this.$exchange = string;
                this.$routingKey = string2;
                this.$message = string3;
                this.$correlationId = string4;
                super(1);
            }
        });
    }

    public static /* synthetic */ void publish$default(RabbitMqClient rabbitMqClient, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        rabbitMqClient.publish(string, string2, string3, string4);
    }

    private final void publish(Channel channel, String exchange, String routingKey, String encoding, String message, String correlationId, String replyQueueName) {
        Charset charset;
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
        CharSequence charSequence = correlationId;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            builder.correlationId(correlationId);
        }
        if (!((charSequence = (CharSequence)replyQueueName) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            builder.replyTo(replyQueueName);
        }
        if (!((charSequence = (CharSequence)encoding) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            builder.contentEncoding(encoding);
        }
        AMQP.BasicProperties props = builder.build();
        if (encoding == null) {
            charset = Charset.defaultCharset();
        } else {
            Charset charset2 = Charset.forName(encoding);
            charset = charset2;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(charsetName)");
        }
        Charset charset3 = charset;
        String string = message;
        Charset charset4 = charset3;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset4, (String)"charset");
        Charset charset5 = charset4;
        AMQP.BasicProperties basicProperties = props;
        String string2 = routingKey;
        String string3 = exchange;
        Channel channel2 = channel;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset5);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        channel2.basicPublish(string3, string2, basicProperties, byArray2);
        this.log.debug((Function0)new Function0<String>(exchange, routingKey, replyQueueName, correlationId, message){
            final /* synthetic */ String $exchange;
            final /* synthetic */ String $routingKey;
            final /* synthetic */ String $replyQueueName;
            final /* synthetic */ String $correlationId;
            final /* synthetic */ String $message;

            @NotNull
            public final String invoke() {
                return StringsKt.trimIndent((String)("\n            EXCHANGE: " + this.$exchange + " ROUTING KEY: " + this.$routingKey + "\n            REPLY TO: " + this.$replyQueueName + " CORRELATION ID: " + this.$correlationId + "\n            BODY:\n            " + this.$message));
            }
            {
                this.$exchange = string;
                this.$routingKey = string2;
                this.$replyQueueName = string3;
                this.$correlationId = string4;
                this.$message = string5;
                super(0);
            }
        });
    }

    @NotNull
    public final String call(@NotNull String requestQueue, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)requestQueue, (String)"requestQueue");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return (String)this.withChannel((Function1)new Function1<Channel, String>(this, requestQueue, message){
            final /* synthetic */ RabbitMqClient this$0;
            final /* synthetic */ String $requestQueue;
            final /* synthetic */ String $message;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@NotNull Channel it) {
                void result;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = UUID.randomUUID().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"randomUUID().toString()");
                String correlationId = string;
                AMQP.Queue.DeclareOk declareOk = it.queueDeclare();
                Intrinsics.checkExpressionValueIsNotNull((Object)declareOk, (String)"it.queueDeclare()");
                String replyQueueName = declareOk.getQueue();
                String charset = Charset.defaultCharset().name();
                RabbitMqClient.access$publish(this.this$0, it, "", this.$requestQueue, charset, this.$message, correlationId, replyQueueName);
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                DefaultConsumer consumer2 = new DefaultConsumer(correlationId, (Ref.ObjectRef)result, it, it){
                    final /* synthetic */ String $correlationId;
                    final /* synthetic */ Ref.ObjectRef $result;
                    final /* synthetic */ Channel $it;

                    public void handleDelivery(@Nullable String consumerTag, @Nullable Envelope envelope, @Nullable AMQP.BasicProperties properties, @Nullable byte[] body) {
                        AMQP.BasicProperties basicProperties = properties;
                        if (Intrinsics.areEqual((Object)(basicProperties != null ? basicProperties.getCorrelationId() : null), (Object)this.$correlationId)) {
                            byte[] byArray = body;
                            if (body == null) {
                                byArray = new byte[]{};
                            }
                            byte[] byArray2 = byArray;
                            Ref.ObjectRef objectRef = this.$result;
                            String string = new String(byArray2, Charsets.UTF_8);
                            objectRef.element = string;
                        }
                    }
                    {
                        this.$correlationId = $captured_local_variable$0;
                        this.$result = $captured_local_variable$1;
                        this.$it = $captured_local_variable$2;
                        super($super_call_param$3);
                    }
                };
                it.basicConsume(replyQueueName, true, (Consumer)consumer2);
                while ((String)result.element == null) {
                    Thread.sleep(5L);
                }
                String string2 = (String)result.element;
                if (string2 == null) {
                    string2 = "";
                }
                return string2;
            }
            {
                this.this$0 = rabbitMqClient;
                this.$requestQueue = string;
                this.$message = string2;
                super(1);
            }
        });
    }

    public RabbitMqClient(@NotNull ConnectionFactory connectionFactory, int poolSize) {
        Intrinsics.checkParameterIsNotNull((Object)connectionFactory, (String)"connectionFactory");
        this.connectionFactory = connectionFactory;
        this.poolSize = poolSize;
        this.log = new Logger((Object)this);
        this.threadPool = Executors.newFixedThreadPool(this.poolSize, new ThreadFactory(this){
            final /* synthetic */ RabbitMqClient this$0;

            @NotNull
            public final Thread newThread(Runnable it) {
                StringBuilder stringBuilder = new StringBuilder().append("rabbitmq-");
                RabbitMqClient rabbitMqClient = this.this$0;
                int n = RabbitMqClient.access$getCount$p(rabbitMqClient);
                RabbitMqClient.access$setCount$p(rabbitMqClient, n + 1);
                return new Thread(it, stringBuilder.append(n).toString());
            }
            {
                this.this$0 = rabbitMqClient;
            }
        });
        this.connection = this.connectionFactory.newConnection();
    }

    public /* synthetic */ RabbitMqClient(ConnectionFactory connectionFactory, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        this(connectionFactory, n);
    }

    public RabbitMqClient(@NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this(Companion.createConnectionFactory$messaging_rabbitmq(uri), 0, 2, null);
    }

    public static final /* synthetic */ Connection access$getConnection$p(RabbitMqClient $this) {
        return $this.connection;
    }

    public static final /* synthetic */ void access$setConnection$p(RabbitMqClient $this, Connection connection) {
        $this.connection = connection;
    }

    public static final /* synthetic */ ConnectionFactory access$getConnectionFactory$p(RabbitMqClient $this) {
        return $this.connectionFactory;
    }

    public static final /* synthetic */ Logger access$getLog$p(RabbitMqClient $this) {
        return $this.log;
    }

    public static final /* synthetic */ int access$getPoolSize$p(RabbitMqClient $this) {
        return $this.poolSize;
    }

    public static final /* synthetic */ void access$publish(RabbitMqClient $this, Channel channel, String exchange, String routingKey, String encoding, String message, String correlationId, String replyQueueName) {
        $this.publish(channel, exchange, routingKey, encoding, message, correlationId, replyQueueName);
    }

    public static final /* synthetic */ int access$getCount$p(RabbitMqClient $this) {
        return $this.count;
    }

    public static final /* synthetic */ void access$setCount$p(RabbitMqClient $this, int n) {
        $this.count = n;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J1\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\t0\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/hexagonkt/messaging/rabbitmq/RabbitMqClient$Companion;", "", "()V", "createConnectionFactory", "Lcom/rabbitmq/client/ConnectionFactory;", "uri", "Ljava/net/URI;", "createConnectionFactory$messaging_rabbitmq", "setVar", "", "T", "value", "setter", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "messaging_rabbitmq"})
    public static final class Companion {
        private final <T> void setVar(T value, Function1<? super T, Unit> setter) {
            if (value != null) {
                setter.invoke(value);
            }
        }

        @NotNull
        public final ConnectionFactory createConnectionFactory$messaging_rabbitmq(@NotNull URI uri) {
            Integer n;
            Integer n2;
            Long l;
            Boolean bl;
            Companion companion;
            String string;
            boolean bl2;
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            String string2 = uri.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri.toString()");
            CharSequence charSequence = string2;
            boolean bl3 = bl2 = !StringsKt.isBlank((CharSequence)charSequence);
            if (!bl2) {
                String string3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            ConnectionFactory cf = new ConnectionFactory();
            cf.setUri(uri);
            String string4 = uri.getQuery();
            if (string4 == null) {
                string4 = "";
            }
            Map params = HttpKt.parseQueryParameters((String)string4);
            Companion companion2 = this;
            String string5 = (String)params.get("automaticRecovery");
            if (string5 != null) {
                string = string5;
                companion = companion2;
                boolean bl4 = Boolean.parseBoolean(string);
                companion2 = companion;
                bl = bl4;
            } else {
                bl = null;
            }
            companion2.setVar(bl, (Function1)new Function1<Boolean, Unit>(cf){
                final /* synthetic */ ConnectionFactory $cf;

                public final void invoke(boolean it) {
                    this.$cf.setAutomaticRecoveryEnabled(it);
                }
                {
                    this.$cf = connectionFactory;
                    super(1);
                }
            });
            Companion companion3 = this;
            String string6 = (String)params.get("recoveryInterval");
            if (string6 != null) {
                string = string6;
                companion = companion3;
                long l2 = Long.parseLong(string);
                companion3 = companion;
                l = l2;
            } else {
                l = null;
            }
            companion3.setVar(l, (Function1)new Function1<Long, Unit>(cf){
                final /* synthetic */ ConnectionFactory $cf;

                public final void invoke(long it) {
                    this.$cf.setNetworkRecoveryInterval(it);
                }
                {
                    this.$cf = connectionFactory;
                    super(1);
                }
            });
            Companion companion4 = this;
            String string7 = (String)params.get("shutdownTimeout");
            if (string7 != null) {
                string = string7;
                companion = companion4;
                int n3 = Integer.parseInt(string);
                companion4 = companion;
                n2 = n3;
            } else {
                n2 = null;
            }
            companion4.setVar(n2, (Function1)new Function1<Integer, Unit>(cf){
                final /* synthetic */ ConnectionFactory $cf;

                public final void invoke(int it) {
                    this.$cf.setShutdownTimeout(it);
                }
                {
                    this.$cf = connectionFactory;
                    super(1);
                }
            });
            Companion companion5 = this;
            String string8 = (String)params.get("heartbeat");
            if (string8 != null) {
                string = string8;
                companion = companion5;
                int n4 = Integer.parseInt(string);
                companion5 = companion;
                n = n4;
            } else {
                n = null;
            }
            companion5.setVar(n, (Function1)new Function1<Integer, Unit>(cf){
                final /* synthetic */ ConnectionFactory $cf;

                public final void invoke(int it) {
                    this.$cf.setRequestedHeartbeat(it);
                }
                {
                    this.$cf = connectionFactory;
                    super(1);
                }
            });
            return cf;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

