/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.messaging.rabbitmq;

import com.hexagonkt.helpers.Logger;
import com.hexagonkt.messaging.rabbitmq.RabbitMqClient;
import com.hexagonkt.messaging.rabbitmq.RabbitMqClientTest;
import com.hexagonkt.serialization.SerializationKt;
import com.rabbitmq.client.ConnectionFactory;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Test
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010\n\u001a\u00020\u0006H\u0007J\b\u0010\u000b\u001a\u00020\u0006H\u0007J\b\u0010\f\u001a\u00020\u0006H\u0007J\b\u0010\r\u001a\u00020\u0006H\u0007J\b\u0010\u000e\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/hexagonkt/messaging/rabbitmq/RabbitMqClientTest;", "", "()V", "log", "Lcom/hexagonkt/helpers/Logger;", "Consumers handle no reply messages", "", "Consumers handle numbers properly", "Create a connection factory with all parameters succeed", "Create a connection factory with empty URI fails", "Create a connection factory with invalid URI fails", "Create a connection factory with one parameter succeed", "Create a connection factory with two parameter succeed", "Create a connection factory without parameters succeed", "Rabbit client disconnects properly", "messaging_rabbitmq"})
public final class RabbitMqClientTest {
    private final Logger log = new Logger((Object)this);

    @Test
    public final void Create a connection factory with empty URI fails() {
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(IllegalArgumentException.class), (Function0)Create a connection factory with empty URI fails.1.INSTANCE);
    }

    @Test
    public final void Create a connection factory with invalid URI fails() {
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(IllegalArgumentException.class), (Function0)Create a connection factory with invalid URI fails.1.INSTANCE);
    }

    @Test
    public final void Create a connection factory without parameters succeed() {
        String uri = "amqp://user:pass@localhost:12345";
        ConnectionFactory cf = RabbitMqClient.Companion.createConnectionFactory$messaging_rabbitmq(new URI(uri));
        boolean bl = Intrinsics.areEqual((Object)cf.getHost(), (Object)"localhost");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl2 = bl = cf.getPort() == 12345;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Test
    public final void Create a connection factory with one parameter succeed() {
        String uri = "amqp://user:pass@localhost:12345?channelCacheSize=50";
        ConnectionFactory cf = RabbitMqClient.Companion.createConnectionFactory$messaging_rabbitmq(new URI(uri));
        boolean bl = Intrinsics.areEqual((Object)cf.getHost(), (Object)"localhost");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl2 = bl = cf.getPort() == 12345;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Test
    public final void Create a connection factory with two parameter succeed() {
        String uri = "amqp://user:pass@localhost:12345?channelCacheSize=50&heartbeat=25";
        ConnectionFactory cf = RabbitMqClient.Companion.createConnectionFactory$messaging_rabbitmq(new URI(uri));
        boolean bl = Intrinsics.areEqual((Object)cf.getHost(), (Object)"localhost");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl2 = bl = cf.getPort() == 12345;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Test
    public final void Create a connection factory with all parameters succeed() {
        List opts = CollectionsKt.listOf((Object[])new String[]{"channelCacheSize=50", "heartbeat=25", "automaticRecovery=true", "recoveryInterval=5", "shutdownTimeout=5"});
        String opt = CollectionsKt.joinToString$default((Iterable)opts, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        String uri = "amqp://user:pass@localhost:12345?" + opt;
        ConnectionFactory cf = RabbitMqClient.Companion.createConnectionFactory$messaging_rabbitmq(new URI(uri));
        boolean bl = Intrinsics.areEqual((Object)cf.getHost(), (Object)"localhost");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl2 = bl = cf.getPort() == 12345;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Test
    public final void Rabbit client disconnects properly() {
        RabbitMqClient client2 = new RabbitMqClient(new URI("amqp://guest:guest@localhost"));
        boolean bl = client2.getConnected();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        client2.close();
        boolean bl2 = bl = !client2.getConnected();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        client2.close();
        boolean bl3 = bl = !client2.getConnected();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Test
    public final void Consumers handle numbers properly() {
        RabbitMqClient consumer2 = new RabbitMqClient(new URI("amqp://guest:guest@localhost"));
        consumer2.declareQueue("int_op");
        consumer2.declareQueue("long_op");
        consumer2.declareQueue("list_op");
        consumer2.consume("int_op", Reflection.getOrCreateKotlinClass(String.class), (Function1)Consumers handle numbers properly.1.INSTANCE);
        consumer2.consume("long_op", Reflection.getOrCreateKotlinClass(String.class), (Function1)Consumers handle numbers properly.2.INSTANCE);
        consumer2.consume("list_op", Reflection.getOrCreateKotlinClass(List.class), (Function1)Consumers handle numbers properly.3.INSTANCE);
        RabbitMqClient client2 = new RabbitMqClient(new URI("amqp://guest:guest@localhost"));
        boolean bl = Intrinsics.areEqual((Object)client2.call("int_op", "123"), (Object)"123");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = Intrinsics.areEqual((Object)client2.call("long_op", "456"), (Object)"456");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = Intrinsics.areEqual((Object)client2.call("list_op", SerializationKt.serialize$default((Object)CollectionsKt.listOf((Object[])new Integer[]{1, 3, 4}), null, (int)1, null)), (Object)SerializationKt.serialize$default((Object)CollectionsKt.listOf((Object[])new Integer[]{1, 3, 4}), null, (int)1, null));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        client2.close();
        consumer2.deleteQueue("int_op");
        consumer2.deleteQueue("long_op");
        consumer2.deleteQueue("list_op");
        consumer2.close();
    }

    @Test
    public final void Consumers handle no reply messages() {
        RabbitMqClient consumer2 = new RabbitMqClient(new URI("amqp://guest:guest@localhost"));
        consumer2.declareQueue("int_handler");
        consumer2.declareQueue("long_handler");
        consumer2.declareQueue("exception_handler");
        consumer2.consume("int_handler", Reflection.getOrCreateKotlinClass(String.class), (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ RabbitMqClientTest this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                RabbitMqClientTest.access$getLog$p(this.this$0).info((Function0)new Function0<String>(it){
                    final /* synthetic */ String $it;

                    @NotNull
                    public final String invoke() {
                        return this.$it;
                    }
                    {
                        this.$it = string;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = rabbitMqClientTest;
                super(1);
            }
        });
        consumer2.consume("long_handler", Reflection.getOrCreateKotlinClass(String.class), (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ RabbitMqClientTest this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                RabbitMqClientTest.access$getLog$p(this.this$0).info((Function0)new Function0<String>(it){
                    final /* synthetic */ String $it;

                    @NotNull
                    public final String invoke() {
                        return this.$it;
                    }
                    {
                        this.$it = string;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = rabbitMqClientTest;
                super(1);
            }
        });
        consumer2.consume("exception_handler", Reflection.getOrCreateKotlinClass(String.class), (Function1)Consumers handle no reply messages.3.INSTANCE);
        RabbitMqClient client2 = new RabbitMqClient(new URI("amqp://guest:guest@localhost"));
        RabbitMqClient.publish$default((RabbitMqClient)client2, (String)"int_handler", (String)"123", null, (int)4, null);
        RabbitMqClient.publish$default((RabbitMqClient)client2, (String)"long_handler", (String)"456", null, (int)4, null);
        RabbitMqClient.publish$default((RabbitMqClient)client2, (String)"exception_handler", (String)"error", null, (int)4, null);
        RabbitMqClient.publish$default((RabbitMqClient)client2, (String)"exception_handler", (String)"", null, (int)4, null);
        client2.close();
        consumer2.deleteQueue("int_handler");
        consumer2.deleteQueue("long_handler");
        consumer2.deleteQueue("exception_handler");
        consumer2.close();
    }

    public static final /* synthetic */ Logger access$getLog$p(RabbitMqClientTest $this) {
        return $this.log;
    }
}

