/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.hexagonkt.helpers.Logger;
import com.hexagonkt.scheduler.CronScheduler;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u0006\u0010\u0016\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/hexagonkt/scheduler/CronScheduler;", "", "threads", "", "(I)V", "cronParser", "Lcom/cronutils/parser/CronParser;", "log", "Lcom/hexagonkt/helpers/Logger;", "scheduler", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "delay", "", "cronExecution", "Lcom/cronutils/model/time/ExecutionTime;", "function", "", "callback", "Lkotlin/Function0;", "schedule", "cronExpression", "", "shutdown", "hexagon_scheduler"})
public final class CronScheduler {
    private final Logger log;
    private final ScheduledThreadPoolExecutor scheduler;
    private final CronParser cronParser;

    public final void schedule(@NotNull String cronExpression, @NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)cronExpression, (String)"cronExpression");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Cron cron = this.cronParser.parse(cronExpression);
        ExecutionTime cronExecution = ExecutionTime.forCron((Cron)cron);
        Runnable runnable = new Runnable(this, callback, cronExecution){
            final /* synthetic */ CronScheduler this$0;
            final /* synthetic */ Function0 $callback;
            final /* synthetic */ ExecutionTime $cronExecution;

            public final void run() {
                ExecutionTime executionTime = this.$cronExecution;
                Intrinsics.checkExpressionValueIsNotNull((Object)executionTime, (String)"cronExecution");
                CronScheduler.access$function(this.this$0, this.$callback, executionTime);
            }
            {
                this.this$0 = cronScheduler;
                this.$callback = function0;
                this.$cronExecution = executionTime;
            }
        };
        ExecutionTime executionTime = cronExecution;
        Intrinsics.checkExpressionValueIsNotNull((Object)executionTime, (String)"cronExecution");
        this.scheduler.schedule(runnable, this.delay(executionTime), TimeUnit.SECONDS);
    }

    public final void shutdown() {
        this.scheduler.shutdown();
    }

    private final long delay(ExecutionTime cronExecution) {
        Object t = cronExecution.timeToNextExecution(ZonedDateTime.now()).orElseThrow(delay.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"cronExecution.timeToNext\u2026()).orElseThrow { error }");
        return ((Duration)t).getSeconds();
    }

    private final void function(Function0<Unit> callback, ExecutionTime cronExecution) {
        try {
            callback.invoke();
        }
        catch (Exception e) {
            this.log.error((Throwable)e, (Function1)function.1.INSTANCE);
        }
        this.scheduler.schedule(new Runnable(this, callback, cronExecution){
            final /* synthetic */ CronScheduler this$0;
            final /* synthetic */ Function0 $callback;
            final /* synthetic */ ExecutionTime $cronExecution;

            public final void run() {
                CronScheduler.access$function(this.this$0, this.$callback, this.$cronExecution);
            }
            {
                this.this$0 = cronScheduler;
                this.$callback = function0;
                this.$cronExecution = executionTime;
            }
        }, this.delay(cronExecution), TimeUnit.SECONDS);
    }

    public CronScheduler(int threads) {
        this.log = new Logger((Object)this);
        this.scheduler = new ScheduledThreadPoolExecutor(threads);
        this.cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public final void run() {
                this.shutdown();
            }
        }));
    }

    public /* synthetic */ CronScheduler(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        this(n);
    }

    public CronScheduler() {
        this(0, 1, null);
    }

    public static final /* synthetic */ void access$function(CronScheduler $this, Function0 callback, ExecutionTime cronExecution) {
        $this.function((Function0<Unit>)callback, cronExecution);
    }
}

