[hexagon_scheduler](../../index.md) / [com.hexagonkt.scheduler](../index.md) / [CronScheduler](./index.md)

# CronScheduler

`class CronScheduler`

Scheduler to execute tasks repeatedly. After using it, you should call the [shutdown](shutdown.md) method. If
the JVM finishes without calling [shutdown](shutdown.md), it will be called upon JVM termination.

``` kotlin
val cron = CronScheduler()
val times = 1
var count = 0

cron.schedule("0/1 * * * * ?") {
    count++
}

sleep((times * 1_000) + 100L)
cron.shutdown()
assert(count == times)
```

### Parameters

`threads` - Number of threads used by the thread pool. By default it is equals to the number
of processors.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `CronScheduler(threads: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = getRuntime().availableProcessors())`<br>Scheduler to execute tasks repeatedly. After using it, you should call the [shutdown](shutdown.md) method. If the JVM finishes without calling [shutdown](shutdown.md), it will be called upon JVM termination. |

### Functions

| Name | Summary |
|---|---|
| [schedule](schedule.md) | `fun schedule(cronExpression: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, callback: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Schedules a block of code to be executed repeatedly by a [Cron](https://en.wikipedia.org/wiki/Cron) expresion. |
| [shutdown](shutdown.md) | `fun shutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Shuts down this scheduler's thread pool. Calling over an already closed scheduler does not have any effect. It is called by the JVM when it is shut down. |
