[hexagon_scheduler](../../index.md) / [com.hexagonkt.scheduler](../index.md) / [CronScheduler](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`CronScheduler(threads: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = getRuntime().availableProcessors())`

Scheduler to execute tasks repeatedly. After using it, you should call the [shutdown](shutdown.md) method. If
the JVM finishes without calling [shutdown](shutdown.md), it will be called upon JVM termination.

``` kotlin
val cron = CronScheduler()
val times = 1
var count = 0

cron.schedule("0/1 * * * * ?") {
    count++
}

sleep((times * 1_000) + 100L)
cron.shutdown()
assert(count == times)
```

### Parameters

`threads` - Number of threads used by the thread pool. By default it is equals to the number
of processors.