/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.uploader;

import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.uploader.FutureHandle;
import com.pinterest.secor.uploader.Handle;
import com.pinterest.secor.uploader.UploadManager;
import com.pinterest.secor.util.FileUtil;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopS3UploadManager
extends UploadManager {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopS3UploadManager.class);
    private static final ExecutorService executor = Executors.newFixedThreadPool(256);

    public HadoopS3UploadManager(SecorConfig config) {
        super(config);
    }

    @Override
    public Handle<?> upload(LogFilePath localPath) throws Exception {
        String s3Prefix = "s3n://" + this.mConfig.getS3Bucket() + "/" + this.mConfig.getS3Path();
        LogFilePath s3Path = localPath.withPrefix(s3Prefix);
        final String localLogFilename = localPath.getLogFilePath();
        final String s3LogFilename = s3Path.getLogFilePath();
        LOG.info("uploading file {} to {}", (Object)localLogFilename, (Object)s3LogFilename);
        Future<?> f = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtil.moveToS3(localLogFilename, s3LogFilename);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return new FutureHandle(f);
    }
}

