/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.main;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.common.TopicPartition;
import com.pinterest.secor.common.ZookeeperConnector;
import com.pinterest.secor.main.LogFilePrinterMain;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperClientMain {
    private static final Logger LOG = LoggerFactory.getLogger(LogFilePrinterMain.class);

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"command");
        OptionBuilder.withDescription((String)"command name.  One of \"delete_committed_offsets\"");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<command>");
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"topic");
        OptionBuilder.withDescription((String)"topic whose offset should be read");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<topic>");
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"partition");
        OptionBuilder.withDescription((String)"kafka partition whose offset should be read");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<partition>");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"p"));
        GnuParser parser = new GnuParser();
        return parser.parse(options, args);
    }

    public static void main(String[] args) {
        try {
            CommandLine commandLine = ZookeeperClientMain.parseArgs(args);
            String command = commandLine.getOptionValue("command");
            if (!command.equals("delete_committed_offsets")) {
                throw new IllegalArgumentException("command has to be one of \"delete_committed_offsets\"");
            }
            SecorConfig config = SecorConfig.load();
            ZookeeperConnector zookeeperConnector = new ZookeeperConnector(config);
            String topic = commandLine.getOptionValue("topic");
            if (commandLine.hasOption("partition")) {
                int partition = ((Number)commandLine.getParsedOptionValue("partition")).intValue();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                zookeeperConnector.deleteCommittedOffsetPartitionCount(topicPartition);
            } else {
                zookeeperConnector.deleteCommittedOffsetTopicCount(topic);
            }
        }
        catch (Throwable t) {
            LOG.error("Zookeeper client failed", t);
            System.exit(1);
        }
    }
}

