/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.common;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.common.TopicPartition;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.zookeeper.DistributedLock;
import com.twitter.common.zookeeper.DistributedLockImpl;
import com.twitter.common.zookeeper.ZooKeeperClient;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConnector {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperConnector.class);
    private SecorConfig mConfig;
    private ZooKeeperClient mZookeeperClient;
    private HashMap<String, DistributedLock> mLocks;
    private String mCommittedOffsetGroupPath;

    protected ZookeeperConnector() {
    }

    public ZookeeperConnector(SecorConfig config) {
        this.mConfig = config;
        this.mZookeeperClient = new ZooKeeperClient(Amount.of((int)1, (Unit)Time.DAYS), this.getZookeeperAddresses());
        this.mLocks = new HashMap();
    }

    private Iterable<InetSocketAddress> getZookeeperAddresses() {
        String zookeeperQuorum = this.mConfig.getZookeeperQuorum();
        String[] hostports = zookeeperQuorum.split(",");
        LinkedList<InetSocketAddress> result = new LinkedList<InetSocketAddress>();
        for (String hostport : hostports) {
            String[] elements = hostport.split(":");
            assert (elements.length == 2) : Integer.toString(elements.length) + " == 2";
            String host = elements[0];
            int port = Integer.parseInt(elements[1]);
            result.add(new InetSocketAddress(host, port));
        }
        return result;
    }

    public void lock(String lockPath) {
        assert (this.mLocks.get(lockPath) == null) : "mLocks.get(" + lockPath + ") == null";
        DistributedLockImpl distributedLock = new DistributedLockImpl(this.mZookeeperClient, lockPath);
        this.mLocks.put(lockPath, (DistributedLock)distributedLock);
        distributedLock.lock();
    }

    public void unlock(String lockPath) {
        DistributedLock distributedLock = this.mLocks.get(lockPath);
        assert (distributedLock != null) : "mLocks.get(" + lockPath + ") != null";
        distributedLock.unlock();
        this.mLocks.remove(lockPath);
    }

    protected String getCommittedOffsetGroupPath() {
        if (Strings.isNullOrEmpty((String)this.mCommittedOffsetGroupPath)) {
            String stripped = StringUtils.strip((String)this.mConfig.getKafkaZookeeperPath(), (String)"/");
            this.mCommittedOffsetGroupPath = Joiner.on((String)"/").skipNulls().join((Object)"", (Object)(stripped.equals("") ? null : stripped), new Object[]{"consumers", this.mConfig.getKafkaGroup(), "offsets"});
        }
        return this.mCommittedOffsetGroupPath;
    }

    private String getCommittedOffsetTopicPath(String topic) {
        return this.getCommittedOffsetGroupPath() + "/" + topic;
    }

    private String getCommittedOffsetPartitionPath(TopicPartition topicPartition) {
        return this.getCommittedOffsetTopicPath(topicPartition.getTopic()) + "/" + topicPartition.getPartition();
    }

    public long getCommittedOffsetCount(TopicPartition topicPartition) throws Exception {
        ZooKeeper zookeeper = this.mZookeeperClient.get();
        String offsetPath = this.getCommittedOffsetPartitionPath(topicPartition);
        try {
            byte[] data = zookeeper.getData(offsetPath, false, null);
            return Long.parseLong(new String(data));
        }
        catch (KeeperException.NoNodeException exception) {
            LOG.warn("path {} does not exist in zookeeper", (Object)offsetPath);
            return -1L;
        }
    }

    public List<Integer> getCommittedOffsetPartitions(String topic) throws Exception {
        ZooKeeper zookeeper = this.mZookeeperClient.get();
        String topicPath = this.getCommittedOffsetTopicPath(topic);
        List partitions = zookeeper.getChildren(topicPath, false);
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (String partitionPath : partitions) {
            String[] elements = partitionPath.split("/");
            String partition = elements[elements.length - 1];
            result.add(Integer.valueOf(partition));
        }
        return result;
    }

    public List<String> getCommittedOffsetTopics() throws Exception {
        ZooKeeper zookeeper = this.mZookeeperClient.get();
        String offsetPath = this.getCommittedOffsetGroupPath();
        List topics = zookeeper.getChildren(offsetPath, false);
        LinkedList<String> result = new LinkedList<String>();
        for (String topicPath : topics) {
            String[] elements = topicPath.split("/");
            String topic = elements[elements.length - 1];
            result.add(topic);
        }
        return result;
    }

    private void createMissingParents(String path) throws Exception {
        ZooKeeper zookeeper = this.mZookeeperClient.get();
        assert (path.charAt(0) == '/') : path + ".charAt(0) == '/'";
        String[] elements = path.split("/");
        String prefix = "";
        for (int i = 1; i < elements.length - 1; ++i) {
            prefix = prefix + "/" + elements[i];
            try {
                zookeeper.create(prefix, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                LOG.info("created path {}", (Object)prefix);
                continue;
            }
            catch (KeeperException.NodeExistsException exception) {
                // empty catch block
            }
        }
    }

    public void setCommittedOffsetCount(TopicPartition topicPartition, long count) throws Exception {
        ZooKeeper zookeeper = this.mZookeeperClient.get();
        String offsetPath = this.getCommittedOffsetPartitionPath(topicPartition);
        LOG.info("creating missing parents for zookeeper path {}", (Object)offsetPath);
        this.createMissingParents(offsetPath);
        byte[] data = Long.toString(count).getBytes();
        try {
            LOG.info("setting zookeeper path {} value {}", (Object)offsetPath, (Object)count);
            zookeeper.setData(offsetPath, data, -1);
        }
        catch (KeeperException.NoNodeException exception) {
            zookeeper.create(offsetPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    public void deleteCommittedOffsetTopicCount(String topic) throws Exception {
        ZooKeeper zookeeper = this.mZookeeperClient.get();
        List<Integer> partitions = this.getCommittedOffsetPartitions(topic);
        for (Integer partition : partitions) {
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            String offsetPath = this.getCommittedOffsetPartitionPath(topicPartition);
            LOG.info("deleting path {}", (Object)offsetPath);
            zookeeper.delete(offsetPath, -1);
        }
    }

    public void deleteCommittedOffsetPartitionCount(TopicPartition topicPartition) throws Exception {
        String offsetPath = this.getCommittedOffsetPartitionPath(topicPartition);
        ZooKeeper zookeeper = this.mZookeeperClient.get();
        LOG.info("deleting path {}", (Object)offsetPath);
        zookeeper.delete(offsetPath, -1);
    }

    protected void setConfig(SecorConfig config) {
        this.mConfig = config;
    }
}

