package com.yan.fastview_library.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.yan.fastview_library.R;


/**
 * Created by heinigger on 16/9/20.
 */
public class TextStyleDetailView extends RelativeLayout {
    private TextView tv_left_text;
    private TextView tv_text;
    private TextView mImageArrow;
    private Drawable mRightArrowDrawable;

    public TextStyleDetailView(Context context) {
        super(context, null);
    }

    public TextStyleDetailView(Context context, AttributeSet attrs) {
        super(context, attrs);
        View view = View.inflate(getContext(), R.layout.view_text_style_detail, this);
        tv_left_text = (TextView) view.findViewById(R.id.tv_left_text);
        tv_text = (TextView) view.findViewById(R.id.tv_text);
        mImageArrow = (TextView) view.findViewById(R.id.image_arrow);
        obtainproperties(context, attrs);
//        mRightArrowDrawable = getContext().getResources().getDrawable(android.R.drawable.arrow_down_float);
    }

    private void obtainproperties(Context context, AttributeSet attrs) {
        TypedArray tp = context.obtainStyledAttributes(attrs, R.styleable.TextStyleDetailView);
        int count = tp.getIndexCount();
        for (int i = 0; i < count; i++) {
            int attr = tp.getIndex(i);
            if (attr == R.styleable.TextStyleDetailView_android_text) {
                tv_text.setText(tp.getString(attr));
            } else if (attr == R.styleable.TextStyleDetailView_android_textColor) {
                tv_text.setTextColor(tp.getColor(attr, Color.BLACK));
            } else if (attr == R.styleable.TextStyleDetailView_android_textSize) {
                tv_text.setTextSize(tp.getDimension(attr, 15));
            } else if (attr == R.styleable.TextStyleDetailView_leftTextSize) {
                tv_left_text.setTextSize(tp.getDimension(attr, 15));
            } else if (attr == R.styleable.TextStyleDetailView_leftTextColor) {
                tv_left_text.setTextColor(tp.getColor(attr, Color.BLACK));
            } else if (attr == R.styleable.TextStyleDetailView_leftText) {
                tv_left_text.setText(tp.getString(attr));
            } else if (attr == R.styleable.TextStyleDetailView_arrowVisible) {
                setArrowVisible(tp.getBoolean(attr, true));
            } else if (attr == R.styleable.TextStyleDetailView_rightText) {
                mImageArrow.setText(tp.getString(attr));
            } else if (attr == R.styleable.TextStyleDetailView_rightTextColor) {
                mImageArrow.setTextColor(tp.getColor(attr, getContext().getResources().getColor(android.R.color.holo_blue_light)));
            }
        }
        tp.recycle();
    }

    public void setText(String text) {
        tv_text.setText(text);
    }

    public void setRightArrowText(String text) {
        mImageArrow.setText(text);
    }

    public void setText(Spanned text) {
        tv_text.setText(text);
    }

    public void setLeftText(String text) {
        tv_left_text.setText(text);
    }

    public void setArrowVisible(boolean arrowVisible) {
        if (arrowVisible)
            mImageArrow.setCompoundDrawables(null, null, mRightArrowDrawable, null);
        else
            mImageArrow.setCompoundDrawables(null, null, null, null);
    }
}
