/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.plugin;

import dev.sigstore.KeylessSignature;
import dev.sigstore.KeylessSigner;
import dev.sigstore.bundle.BundleFactory;
import dev.sigstore.rekor.client.RekorEntry;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.FilesCollector;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="sign", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SigstoreSignAttachedMojo
extends AbstractMojo {
    @Parameter(property="sigstore.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="false", property="public-staging")
    private boolean publicStaging;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        FilesCollector collector = new FilesCollector(this.project, this.excludes, this.getLog());
        List items = collector.collect();
        this.getLog().info((CharSequence)("Signing " + items.size() + " file" + (items.size() > 1 ? "s" : "") + "."));
        try {
            KeylessSigner signer = this.publicStaging ? KeylessSigner.builder().sigstoreStagingDefaults().build() : KeylessSigner.builder().sigstorePublicDefaults().build();
            for (FilesCollector.Item item : items) {
                File fileToSign = item.getFile();
                this.getLog().info((CharSequence)("Signing " + fileToSign));
                long start = System.currentTimeMillis();
                KeylessSignature signature = signer.signFile(fileToSign.toPath());
                String sigstoreBundle = BundleFactory.createBundle((KeylessSignature)signature);
                File signatureFile = new File(fileToSign + ".sigstore");
                FileUtils.fileWrite((File)signatureFile, (String)"UTF-8", (String)sigstoreBundle);
                long duration = System.currentTimeMillis() - start;
                this.getLog().info((CharSequence)("        > " + signatureFile.getName() + " in " + duration + " ms"));
                this.projectHelper.attachArtifact(this.project, item.getExtension() + ".sigstore", item.getClassifier(), signatureFile);
                this.getLog().info((CharSequence)("          Rekor logIndex: " + ((RekorEntry)signature.getEntry().get()).getLogIndex()));
                X509Certificate cert = (X509Certificate)signature.getCertPath().getCertificates().get(0);
                this.getLog().info((CharSequence)("          Certificate Issuer DN: " + cert.getIssuerDN()));
                this.getLog().info((CharSequence)("                      Subject Alternative Names: " + cert.getSubjectAlternativeNames()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while signing with sigstore", e);
        }
    }
}

